
//+--------------------------------------------------------------------------+
//|                                                                 ATRA4.mq4 |
//| Vinicius Arruda Vanazzi                                                  |
//| programadorvinicius@gmail.com                                            |
//+--------------------------------------------------------------------------+
#define IND "ATRA[FISHER]"
#define VER " 2.5"
#property copyright "Vinicius Arruda Vanazzi"
#property link      "programadorvinicius@gmail.com"
#property indicator_chart_window
#property indicator_buffers 8
#property indicator_color1 Gray
#property indicator_color2 Blue
#property indicator_color3 Red
#property indicator_color4 Aqua
#property indicator_color5 Aquamarine
#property indicator_color6 Red
#property indicator_color7 Red
#property indicator_color8 DarkOrange
#property indicator_color9 LawnGreen
#property indicator_color10 LawnGreen
#property indicator_color11 LawnGreen
#property indicator_color12 LawnGreen

//////////////////////////////
// CONFIGURAO
//////////////////////////////
extern bool MONEY_MANEGER = false;
int M_1  = 1000;
int M_2  = 2000;
int M_3  = 3000;
int M_4  = 4000;
int M_5  = 5000;
int M_6  = 6000;
int M_7  = 7000;
int M_8  = 8000;
int M_9  = 9000;
int M_10 = 10000;

extern double  QT = 0.1; // 0.40 default
extern double  QT_spread = 0.1;
extern double  QT_MAX = 0.2; // 0.40 default
extern int     decimais_multiplo = 1;
extern int Sintonia_Radar2 = 13;
string L_OBJECT = "";
int cnt_news = 0;
//////////////////////////////
// tabela de risco
//////////////////////////////
int MMA[10];

//////////////////////////////
// CONFIGURAO
//////////////////////////////
extern int     nobs     =150; //Number of bars to process for filter evaluation
extern double  lambda=1600; //Higher lambda leads to the smoother data
extern int     trend    =1; //how many consecutive filter bars to check to determine trend
extern bool    Opera_Bordas = true;
extern bool    Borda_Inversa = false;
extern int     future   =8; //How many bars in the future to display for the HP filter

extern bool LA = true;
int         ILA = 0;
extern bool LB = true;
int         ILB = 0;
extern bool LF = true;
extern bool LG = false;
double distancia = 0;
double caixa = 0;
string arquivo_nome = "_ATRAI.INI";
/////////
// placar indicadores
/////////
extern int scaleX=20,
           scaleY=20,
           offsetX=35,
           offsetY=20,
           fontSize=20,
           corner=2,
           symbolCodeBuy=110, //67
           symbolCodeSell=110, //68
           symbolCodeNoSignal=110; //73
           
extern color signalBuyColor=Green,
             signalSellColor=Red,
             noSignalColor=WhiteSmoke,
             textColor=Gold;
int period[]={1,5,15,30,60,240,1440,10080,43200};
string periodString[]={"M1","M5","M15","M30","H1","H4","D1","W1","MN1"};
       // create one more array with indicator names
string signalNameString[]={"MA","WPR","SAR"};             
//////////////////////////////
// Dados para a Filmagem
//////////////////////////////

//+------------------------------------------------------------------+
extern int   ScreenShotViniStep  = 3;
extern int ScreenShotStep=10000;       // screenshotting step: <=0-not applicable, N-on each Nth bar
extern double ScreenShotCur=0;        // number of the initial screenshot
//+-----------------------------------------------------------------------------+
datetime ScreenShotStart=0; // date and time of the first screenshotting
int ScreenShotMax=100;      // how many screenshots should be made
string FilesPrefix="_";     // prefix for screenshot filenames
datetime   NextScreenShot=0;       // date and time for making the next screenshot
int    ScreenShotVini=0;            // prepare a screenshot counter
double ScreenShotCnt=0;            // prepare a screenshot counter
string FileName;                   // filename to save the next screenshot
int numloop; 


//////////////////////////////
// Gestor de Erros:
//////////////////////////////

//////////////////////////////
// Dados para o Processador
//////////////////////////////
double         cod_operacao = 0;
double         L_cod_operacao = 0;
int            dotry = 6;
int            try = 0;
int            NUM_CONTA = 1;  
string         msg;
string         ordem_enviada;
int spread = 0;

int            compra_hora;
double         stopLoss;
int            num_oper_hora;


double         ganho1 = 0;
double         ganho2 = 0;
double         ganho3 = 0;
double         ganho0 = 0;
double         L_ganho = 0;
bool           Duvida = false;
double         gatilho[10];
bool           gat10 = false;
bool           gat50 = false;
bool           gat100 = false;
//string         data = "0";
int            gatilho_abertura = 0; 
// MT
int            VMTPosicao = 0;
int            NEUTRO = 0;
string         exp_array[100];
//////////////////////////////
// Controle das ordens
//////////////////////////////
double Tickets[10][12];// array to store information about "friendly" orders:
double mem_Tickets[][12];// array to store information about "friendly" orders:
string TicketsC[10];// array to store information about "friendly" orders:
string mem_TicketsC[];// array to store information about "friendly" orders:
// Tickets[][0] - ticket number
// Tickets[][1] - order type
// Tickets[][2] - lots
// Tickets[][3] - open price
// Tickets[][4] - Stop Loss
// Tickets[][5] - TakeProfit
// Tickets[][6] - MagicNumber
// Tickets[][7] - expiration time
// Tickets[][8] - open time
// Tickets[][9] - Symbol
// Tickets[][10] - DirecaoSolicitada
// Tickets[][11] - CONTA
// Tickets
int OrderTicketV = 0;
int OrderTypeV = 1;
int OrderLotsV = 2;
int OrderOpenPriceV = 3;
int OrderStopLossV = 4;
int OrderTakeProfitV = 5;
int OrderMagicNumberV = 6;
int OrderExpirationV = 7;
int OrderOpenTimeV = 8;
int OrderSymbolV = 9;
int DirecaoSolicitada = 10;
int Cod_Conta = 11;
// TicketsC
int OrderCommentV = 0;
extern int    Digit_Normalize = 5; // 4 ou 5 depende da corretora
int cnt = 0;             
string passos;
string debug;
//Input parameters

extern int timeframe=0;//The applied timeframe, 0=the same as chart
extern int price    =PRICE_CLOSE;//The applied price
extern int delay    =0; //Shows the result of delaying (or advancing if negative) the HP filter
extern int bands     = 0; //how many bars to include in bands calculation
extern double band1 =2; //deviations for first band
extern double band2 =2; //deviations for second Band
extern int type1    =-1; //Type for the first band -1=Filter Band or else Price Band 0=applied price 1=mean 2=exterme High/Low 3=inside High/Low 4=median 5=typical 6=weighted
extern int type2    =0; //Type for second band as above
extern bool repaint =false; //To repaint last bar, FALSE for faster execution
extern bool points  =FALSE; //Plot up/downtrend as points instead of line
extern bool alerts  =true; //Enable visual alert
extern string audio ="alert.wav"; //Enable audioalert
extern int history  =500; //history bars to display on initialisation, 0 means all history
double digits_corretora = 4;
//Indicator buffers
double hp0[], hpu0[],hpd0[],hpf0[], fhi0[], flo0[], phi0[], plo0[];
//Global vars
double hp[], hpu[],hpd[],hpf[], fhi[], flo[], phi[], plo[];
double dat[],a[],b[],c[];
datetime time;
string tframe;
bool alerting;
bool showf;

///////////////////////////////////////////////////////////
//  REGRESAO
///////////////////////////////////////////////////////////

// ---- inputs
// dp_limiter  It should be >2 . If not it will be autoset to default value
// endpos      Last value position to the right. It should be >0. If not it will be autoset to
//             default value
// record      [true] - record on; [false] - record off
extern int       dp_limiter   =500;             // Number of data points
extern int       endpos       =0;               // Last value position
extern double    multStdDev   =1.96;            // Bands separation
extern bool      record       =false;           // Record info into a file text

// ---- buffers
double RegBfr[];
double BandUpBfr[];
double BandDwBfr[];
double AuxRegBfr[];

// ---- global variables
int      pos,
         c_handle,p_handle,
         current_day,previous_day,
         datapoints;
double   sumxvalues[1],
         sumyxvalues[1],
         matrix[1][10],
         constant[1],
         errorstddev[4];

// news
string data;
int    hora_utc = -3;
string acao;
string acao1;
string acao2;
string acao3;
string acao4;
string acao5;

////////////////////////
// grafista
////////////////////////

extern color Color_resistance = Orange;
extern color Color_support     = Aqua;
extern int Set=4,
           time_set=10;
int X1u,X2u,X3u,X1d,X2d,X3d,bar_1u,bar_2u,bar_3u,bar_1d,bar_2d,bar_3d,time_period,
    X1g,X2g,per;
double Y1vg,Y2vg,Y1ng,Y2ng,Y1u,Y2u,Y3u,Y1d,Y2d,Y3d;
double channel_width;
extern bool delete_segments = true;//delete segments after the period change

/////////////////////////
//  Registra modificaes
/////////////////////////
string ws1,ws2,ws3;
bool   wb1,wb2,wb3;
int    wi1,wi2,wi3;
double wd1,wd2,wd3;
int    saveb = 0;
//+----------------------------------------------------------------------------------------+
int init()
{
   digits_corretora = MarketInfo(Symbol(),MODE_DIGITS);

   acao = data+"-Seja bem vindo ao Fisher II \n Developer by Vinicius A. Vanazzi ";
   //IndicatorBuffers(11);
   per=Period();
   if (timeframe==0) timeframe=Period();
   SetIndexBuffer(0,hp0);
   SetIndexStyle(0,DRAW_LINE,1);
   SetIndexLabel(0,"hpma");
   SetIndexBuffer(1,hpu0);
   SetIndexLabel(1,"up");
   SetIndexBuffer(2,hpd0);
   SetIndexLabel(2,"down");
   if (points) {
     SetIndexStyle(1,DRAW_ARROW);
     SetIndexArrow(1,4);
     SetIndexStyle(2,DRAW_ARROW);
     SetIndexArrow(2,4);
   } else {
     SetIndexStyle(1,DRAW_LINE);  
     SetIndexStyle(2,DRAW_LINE);  
   }  
   SetIndexBuffer(3,hpf0);
   if (trend>0) {
     SetIndexStyle(3,DRAW_LINE);
     SetIndexLabel(3,"filter");
     SetIndexShift(3,future);
   } else    
     SetIndexStyle(3,DRAW_LINE);
     SetIndexBuffer(4,fhi0);
   //SetIndexBuffer(5,flo0);
   //SetIndexBuffer(6,phi0);
   //SetIndexBuffer(7,plo0);
   if (history==0) history=iBarShift(NULL,0,iTime(NULL,timeframe,iBars(NULL,timeframe)-nobs)); 
   SetIndexDrawBegin(0,Bars-history);
   SetIndexDrawBegin(1,Bars-history);
   SetIndexDrawBegin(2,Bars-history);
   SetIndexDrawBegin(3,Bars-history+future);
   
   if (bands>0 && band1!=0) {
     //SetIndexLabel(4,"Fhi");
     //SetIndexLabel(5,"Flo");
     //SetIndexStyle(4,DRAW_LINE);

     //SetIndexStyle(5,DRAW_LINE);
     if (band1>0) {
       //SetIndexDrawBegin(4,Bars-history);
       //SetIndexDrawBegin(5,Bars-history);
     }  
   } else {
     //SetIndexStyle(4,DRAW_NONE);
     //SetIndexStyle(5,DRAW_NONE);
   }  
   if (bands>0 && band2!=0) {
     //SetIndexLabel(6,"Phi");
    // SetIndexLabel(7,"Plo");
     //SetIndexStyle(6,DRAW_LINE);
     //SetIndexStyle(7,DRAW_LINE);
     if (band2>0) {
       //SetIndexDrawBegin(6,Bars-history);
       //SetIndexDrawBegin(7,Bars-history);
     }  
   } else {
     //SetIndexStyle(6,DRAW_NONE);
     //SetIndexStyle(7,DRAW_NONE);
   }  

      // ---- drawing settings
   SetIndexStyle(4,DRAW_LINE);
   SetIndexBuffer(4,RegBfr);

   SetIndexStyle(5,DRAW_LINE);
   SetIndexLabel(5,"UpperBand");
   SetIndexBuffer(5,BandUpBfr);

   SetIndexStyle(6,DRAW_LINE);
   SetIndexLabel(6,"LowerBand");
   SetIndexBuffer(6,BandDwBfr);

   // ---- mapping
   SetIndexBuffer(7,AuxRegBfr);   
  
   
   ArrayResize(hpf,nobs);
   ArrayResize(dat,nobs);
   ArrayResize(a,nobs);
   ArrayResize(b,nobs);
   ArrayResize(c,nobs);
   time=Time[history-1];
   if (lambda<1) lambda=MathExp(-lambda);
   switch (timeframe) {
     case 60:{tframe="H1";break;}
     case 240:{tframe="H4";break;}
     case 1440:{tframe="D1";break;}
     case 10080:{tframe="W1";break;}
     case 43200:{tframe="MN1";break;}
     default:tframe="M"+Period();
   }
   IndicatorShortName(IND+"("+tframe+")");
   tframe=Symbol()+" "+tframe+": ";   
   history=MathMax(iBarShift(NULL,timeframe,time),bands);
   if (history==0)  history = nobs;
   ArrayResize(hp,history);
   ArrayResize(hpu,history);
   ArrayResize(hpd,history);
   ArrayResize(fhi,history);
   ArrayResize(flo,history);
   ArrayResize(phi,history);
   ArrayResize(plo,history);
   alerting=alerts || audio!="";
   showf=trend>0;
   if (trend<0) trend=-trend; 
   
   // ---- checking inputs
   if(dp_limiter<3)
      {
       dp_limiter=100;
      }                        
   if(endpos<0)
      {
       endpos=0;
      }                        

///////////

    for(int x=0;x<9;x++)
      for(int y=0;y<3;y++)
      {
         ObjectCreate("signal"+x+y,OBJ_LABEL,0,0,0,0,0);
         ObjectSet("signal"+x+y,OBJPROP_CORNER,corner);
         ObjectSet("signal"+x+y,OBJPROP_XDISTANCE,x*scaleX+offsetX);
         ObjectSet("signal"+x+y,OBJPROP_YDISTANCE,y*scaleY+offsetY);
         ObjectSetText("signal"+x+y,CharToStr(symbolCodeNoSignal),
                       fontSize,"Wingdings",noSignalColor);
      }
 
   // names of timeframes
   for(x=0;x<9;x++)
   {
      ObjectCreate("textPeriod"+x,OBJ_LABEL,0,0,0,0,0);
      ObjectSet("textPeriod"+x,OBJPROP_CORNER,corner);
      ObjectSet("textPeriod"+x,OBJPROP_XDISTANCE,x*scaleX+offsetX);
      ObjectSet("textPeriod"+x,OBJPROP_YDISTANCE,offsetY-10);
      ObjectSetText("textPeriod"+x,periodString[x],8,"Tahoma",textColor);
   }
 
   // names of indicators
   for(y=0;y<3;y++)
   {
      ObjectCreate("textSignal"+y,OBJ_LABEL,0,0,0,0,0);
      ObjectSet("textSignal"+y,OBJPROP_CORNER,corner);
      ObjectSet("textSignal"+y,OBJPROP_XDISTANCE,offsetX-25);
      ObjectSet("textSignal"+y,OBJPROP_YDISTANCE,y*scaleY+offsetY+8);
      ObjectSetText("textSignal"+y,signalNameString[y],8,"Tahoma",textColor);
   }


   return(0);
}
//+----------------------------------------------------------------------------------------+
//////////////////
string Direcao(int salto1)
{
  string resp = "";
  double salto;
  double salto2;

   salto  = (Open[0] - Close[0]);
   salto2 = (High[1] - Low[1])/4; 
   if (salto <  salto2) resp = "Alta";
   if (salto >  salto2) resp = "Baixa";
   if (resp == "") resp = "Neutro";
   return(resp);

}

///////////////////

double MTFindePapel(double VPapel)
{
if (MTTotal() > 0)
{
 int countt = 0;
 for (int ii=0; ii <= MTTotal(); ii++)
 {
   if (VPapel == Tickets[ii][9])
   {
     return(true); 
   }
 }
}
return(false);
}


int Carregamento()
{
  //if (IsDemo()) return(0);
  //if (IsDemo()) return(0);
  if (OrdersTotal() != 0)
    {
        for(int i=0;i<OrdersTotal();i++)
        {      
          if (OrderSelect(i,SELECT_BY_POS))
          {

            if ((OrderComment() == (Symbol()+"CR")))
            {
             Tickets[0][0] = OrderTicket();
             Tickets[0][OrderTypeV] = OrderType();
             Tickets[0][2] = OrderLots();
             Tickets[0][3] = OrderOpenPrice();
             Tickets[0][4] = OrderStopLoss();
             Tickets[0][5] = OrderTakeProfit();
             Tickets[0][6] = OrderMagicNumber();
             Tickets[0][7] = OrderExpiration();
             Tickets[0][8] = OrderOpenTime();         
             Tickets[0][9] = cod_papel(OrderSymbol());       
             Tickets[0][11] = 1; // CONTA
            }
           
            //if ((OrderComment() == (Symbol()+"LA")) && (Tickets[1][11] != 2))
            if ((OrderComment() == (Symbol()+"LA")))
            {
             Tickets[1][0] = OrderTicket();
             Tickets[1][OrderTypeV] = OrderType();
             Tickets[1][2] = OrderLots();
             Tickets[1][3] = OrderOpenPrice();
             Tickets[1][4] = OrderStopLoss();
             Tickets[1][5] = OrderTakeProfit();
             Tickets[1][6] = OrderMagicNumber();
             Tickets[1][7] = OrderExpiration();
             Tickets[1][8] = OrderOpenTime();         
             Tickets[1][9] = cod_papel(OrderSymbol());       
             Tickets[1][11] = 2; // CONTA      
              //Print("Cod ST01: Carregando LA na memoria ");
            }
            
            //if ((OrderComment() == (Symbol()+"LB")) && (Tickets[2][11] != 3))           
            if ((OrderComment() == (Symbol()+"LB")))           
            {
             Tickets[2][0] = OrderTicket();
             Tickets[2][OrderTypeV] = OrderType();
             Tickets[2][2] = OrderLots();
             Tickets[2][3] = OrderOpenPrice();
             Tickets[2][4] = OrderStopLoss();
             Tickets[2][5] = OrderTakeProfit();
             Tickets[2][6] = OrderMagicNumber();
             Tickets[2][7] = OrderExpiration();
             Tickets[2][8] = OrderOpenTime();         
             Tickets[2][9] = cod_papel(OrderSymbol());       
             Tickets[2][11] = 3; // CONTA       
              //Print("Cod ST01: Carregando LB na memoria ");
            }
          } 
           
       }           
             
   } 
}

string tf()
{
   switch(Period())
   {
      case PERIOD_M1: return("M(1)");
      case PERIOD_M5: return("M(5)");
      case PERIOD_M15: return("M(15)");
      case PERIOD_M30: return("M(30)");
      case PERIOD_H1: return("H(1)");
      case PERIOD_H4: return("H(4)");
      case PERIOD_D1: return("D(1)");
      case PERIOD_W1: return("W(1)");
      case PERIOD_MN1: return("MN(1)");
      default:return("Unknown timeframe");
   }
}

//============================================
double find_papel(int conta,int sentido)
{
string cont = "";
if (conta == 1) cont = Symbol()+"CR"; 
if (conta == 2) cont = Symbol()+"LB"; 
if (conta == 3) cont = Symbol()+"LA"; 
if(IsDemo())
{
if (conta == 0) conta = 1;
          if (Tickets[conta-1][Cod_Conta] == conta)
          if (Tickets[conta-1][OrderTypeV] == sentido)
              return(Tickets[conta-1][OrderOpenPriceV]); 

} else
{
        for(int i=0;i<OrdersTotal();i++)
        {      
          if (OrderSelect(i,SELECT_BY_POS))
          {
          if(OrderSymbol()==Symbol())  // if (!isOurOrder(OrderTicket()))
          {
            if ((OrderComment() == cont) && (OrderType() == sentido))
            {
              return(OrderOpenPrice()); 
            }
          }
          }
        }
}
return(0);        
}

/////////////////////////////////////////
int regressao()
{
   //Comment(" Pressesando ");
   double H1,H2,H3,H4,H5,HH1,HH2,HH3,HH4,HH5,HB,HC,Z,V;
   int i, disp, bar, limit;
   if (iBars(NULL,timeframe)<nobs) return(0);
   if (!repaint && time==Time[0]) return(0); 
   limit=iBarShift(NULL,timeframe,time);
   time=Time[0];
   if (limit>=history) limit=history-1;
   if (limit<history-1)
     for (bar=history-1-limit; bar>=0; bar--) {
       hp[bar+limit] =hp[bar];
       hpu[bar+limit]=hpu[bar];
       hpd[bar+limit]=hpd[bar];
       fhi[bar+limit]=fhi[bar];
       flo[bar+limit]=flo[bar];
       phi[bar+limit]=phi[bar];
       plo[bar+limit]=plo[bar];
     }
   for (bar=limit; bar>=0; bar--) {
     hpu[bar]=EMPTY_VALUE;
     hpd[bar]=EMPTY_VALUE;
     fhi[bar]=EMPTY_VALUE;
     flo[bar]=EMPTY_VALUE;
     phi[bar]=EMPTY_VALUE;
     plo[bar]=EMPTY_VALUE;
     H1=0;H2=0;H3=0;H4=0;H5=0;HH1=0;HH2=0;HH3=0;HH4=0;HH5=0;
     switch (price) {
       case PRICE_CLOSE: {for(i=0;i<nobs;i++) dat[i]=iClose(NULL,timeframe,bar+i);break;}
       case PRICE_OPEN: {for(i=0;i<nobs;i++)dat[i]=iOpen(NULL,timeframe,bar+i);break;}
       case PRICE_HIGH: {for(i=0;i<nobs;i++)dat[i]=iHigh(NULL,timeframe,bar+i);break;}
       case PRICE_LOW: {for(i=0;i<nobs;i++)dat[i]=iLow(NULL,timeframe,bar+i);break;}
       case PRICE_MEDIAN: {for(i=0;i<nobs;i++)dat[i]=(iHigh(NULL,timeframe,bar+i)+iLow(NULL,timeframe,bar+i))/2;break;}
       case PRICE_TYPICAL: {for(i=0;i<nobs;i++)dat[i]=(iHigh(NULL,timeframe,bar+i)+iLow(NULL,timeframe,bar+i)+iClose(NULL,timeframe,bar+i))/3;break;}
       case PRICE_WEIGHTED: {for(i=0;i<nobs;i++)dat[i]=(iHigh(NULL,timeframe,bar+i)+iLow(NULL,timeframe,bar+i)+2*iClose(NULL,timeframe,bar+i))/4;break;}
       default: for(i=0;i<nobs;i++) dat[i]=(iHigh(NULL,timeframe,bar+i)+iLow(NULL,timeframe,bar+i)+iOpen(NULL,timeframe,bar+i)+iClose(NULL,timeframe,bar+i))/4;
     }
     V=dat[0];  
     a[0]=1.0+lambda;
     b[0]=-2.0*lambda;
     c[0]=lambda;
     for(i=1;i<nobs-2;i++)
     {
        a[i]=6.0*lambda+1.0;
        b[i]=-4.0*lambda;
        c[i]=lambda;
     }
     a[1]=5.0*lambda+1;
     a[nobs-1]=1.0+lambda;
     a[nobs-2]=5.0*lambda+1.0;
     b[nobs-2]=-2.0*lambda;
     b[nobs-1]=0.0;
     c[nobs-2]=0.0;
     c[nobs-1]=0.0;
   
   //Forward
     for(i=0;i<nobs;i++)
     {
        Z=a[i]-H4*H1-HH5*HH2;
        HB=b[i];
        HH1=H1;
        H1=(HB-H4*H2)/Z;
        b[i]=H1;
        HC=c[i];
        HH2=H2;
        H2=HC/Z;
        c[i]=H2;
        a[i]=(dat[i]-HH3*HH5-H3*H4)/Z;
        HH3=H3;
        H3=a[i];
        H4=HB-H5*HH1;
        HH5=H5;
        H5=HC;
     }
   
   //Backward 
     H2=0;
     H1=a[nobs-1];
     hpf[nobs-1]=H1;
     for(i=nobs-2;i>=0;i--)
     {
        hpf[i]=a[i]-b[i]*H1-c[i]*H2;
        H2=H1;
        H1=hpf[i];
     }
     hp[bar]=hpf[0];
     if (hpu[bar+1]==EMPTY_VALUE && (hp[bar]<hp[bar+1] || V<hp[bar]))  
       hpu[bar]=EMPTY_VALUE;
     else if (trend>0) {  
       for (i=0; i<trend; i++)
         if (hpf[i]<hpf[i+1]) break;
       if (i<trend)  
         hpu[bar]=EMPTY_VALUE;
       else  
         hpu[bar]=hpf[0];
     } else {
       if (hp[bar]<hp[bar+1])  
         hpu[bar]=EMPTY_VALUE;
       else  
         hpu[bar]=hpf[0];
     }   
     if (hpd[bar+1]==EMPTY_VALUE && (hp[bar]>hp[bar+1] || V>hp[bar]))  
       hpd[bar]=EMPTY_VALUE;
     else if (trend>0) {  
       for (i=0; i<trend; i++)
         if (hpf[i]>hpf[i+1]) break;
       if (i<trend)  
         hpd[bar]=EMPTY_VALUE;
       else  
         hpd[bar]=hpf[0];
     } else {
       if (hp[bar]>hp[bar+1])  
         hpd[bar]=EMPTY_VALUE;
       else  
         hpd[bar]=hpf[0];
     }
     if (bands>0 && (band1>0  || (band1<0 && bar==0))) {
       Z=0;    
       for (i=0; i<bands; i++) {
         V=hpf[i];
         switch (type1) {
           case -1: {V-=hp[bar+i];break;}
           case 0: {V-=dat[i];break;}
           case 1: {V-=(2*(iHigh(NULL,timeframe,bar+i)+iLow(NULL,timeframe,bar+i))+iOpen(NULL,timeframe,bar+i)+iClose(NULL,timeframe,bar+i))/6;break;}
           case 2: {V=MathMax(MathAbs(iHigh(NULL,timeframe,bar+i)-V),MathAbs(iLow(NULL,timeframe,bar+i)-V));break;}
           case 3: {V=MathMin(MathAbs(iHigh(NULL,timeframe,bar+i)-V),MathAbs(iLow(NULL,timeframe,bar+i)-V));break;}
           case 4: {V-=(iHigh(NULL,timeframe,bar+i)+iLow(NULL,timeframe,bar+i))/2;break;}
           case 5: {V-=(iHigh(NULL,timeframe,bar+i)+iLow(NULL,timeframe,bar+i)+iClose(NULL,timeframe,bar+i))/3;break;}
           case 6: {V-=(iHigh(NULL,timeframe,bar+i)+iLow(NULL,timeframe,bar+i)+2*iClose(NULL,timeframe,bar+i))/4;break;}
           default: V-=iClose(NULL,timeframe,bar+i);
         }
         Z+=V*V;
       }
       Z=band1*MathSqrt(Z/bands);
       if (band1>0) {
         fhi[bar]=hp[bar]+Z;
         flo[bar]=hp[bar]-Z;
       } else {
         limit=iBarShift(NULL,0,iTime(NULL,timeframe,nobs-1));
         SetIndexDrawBegin(6,limit);
         SetIndexDrawBegin(7,limit);
         for (i=0; i<nobs; i++) {
           fhi[i]=hpf[i]-Z;
           flo[i]=hpf[i]+Z;
         }  
       }  
     }  
     if (bands>0 && (band2>0  || (band2<0 && bar==0))) {
       Z=0;    
       for (i=0; i<bands; i++) {
         V=hpf[i];
         switch (type2) {
           case -1: {V-=hp[bar+i];break;}
           case 0: {V-=dat[i];break;}
           case 1: {V-=(2*(iHigh(NULL,timeframe,bar+i)+iLow(NULL,timeframe,bar+i))+iOpen(NULL,timeframe,bar+i)+iClose(NULL,timeframe,bar+i))/6;break;}
           case 2: {V=MathMax(MathAbs(iHigh(NULL,timeframe,bar+i)-V),MathAbs(iLow(NULL,timeframe,bar+i)-V));break;}
           case 3: {V=MathMin(MathAbs(iHigh(NULL,timeframe,bar+i)-V),MathAbs(iLow(NULL,timeframe,bar+i)-V));break;}
           case 4: {V-=(iHigh(NULL,timeframe,bar+i)+iLow(NULL,timeframe,bar+i))/2;break;}
           case 5: {V-=(iHigh(NULL,timeframe,bar+i)+iLow(NULL,timeframe,bar+i)+iClose(NULL,timeframe,bar+i))/3;break;}
           case 6: {V-=(iHigh(NULL,timeframe,bar+i)+iLow(NULL,timeframe,bar+i)+2*iClose(NULL,timeframe,bar+i))/4;break;}
           default: V-=iClose(NULL,timeframe,bar+i);
         }
         Z+=V*V;
       }  
       Z=band2*MathSqrt(Z/bands);
       if (band2>0) {
         phi[bar]=hp[bar]+Z;
         plo[bar]=hp[bar]-Z;
       } else {
         limit=iBarShift(NULL,0,iTime(NULL,timeframe,nobs-1));
         SetIndexDrawBegin(4,limit);
         SetIndexDrawBegin(5,limit);
         for (i=0; i<nobs; i++) {
           phi[i]=hpf[i]-Z;
           plo[i]=hpf[i]+Z;
         }  
       }  
     }  
     if (bar<history-1) {
       if (bar==0)
         disp=0;
       else if (timeframe<=Period())
         disp=iBarShift(NULL,0,iTime(NULL,timeframe,bar));
       else  
         disp=iBarShift(NULL,0,iTime(NULL,timeframe,bar-1))+1;
       if (delay>=0)
         hp0[disp]=hpf[delay];
       else
         hp0[disp]=newt(hpf,0,-delay);
       if (hpu[bar]!=EMPTY_VALUE)
         hpu0[disp]=hp0[disp];
       else    
         hpu0[disp]=EMPTY_VALUE;
       if (hpd[bar]!=EMPTY_VALUE)
         hpd0[disp]=hp0[disp];
       else  
         hpd0[disp]=EMPTY_VALUE;
       fhi0[disp]=fhi[bar];
       flo0[disp]=flo[bar];
       phi0[disp]=phi[bar];
       plo0[disp]=plo[bar];
       if (timeframe<=Period())
         limit=iBarShift(NULL,0,iTime(NULL,timeframe,bar+1));
       else  
         limit=iBarShift(NULL,0,iTime(NULL,timeframe,bar))+1;
       i=limit-disp;
       if (i<2) continue;
       H1=hp[bar+1];
       HH1=(hp[bar]-H1)/i;
       if (bands>0 && band1>0) {
         H2=fhi[bar+1];
         HH2=(fhi[bar]-H2)/i;
         H3=flo[bar+1];
         HH3=(flo[bar]-H3)/i;
       }
       if (bands>0 && band2>0) {
         H4=phi[bar+1];
         HH4=(phi[bar]-H4)/i;
         H5=plo[bar+1];
         HH5=(plo[bar]-H5)/i;
       }
       for (i=limit-1; i>disp; i--) {
         H1+=HH1;
         hp0[i]=H1;
         if (hpu[bar+1]!=EMPTY_VALUE) hpu0[i]=H1; else hpu0[i]=EMPTY_VALUE;
         if (hpd[bar+1]!=EMPTY_VALUE) hpd0[i]=H1; else hpd0[i]=EMPTY_VALUE;
         if (bands>0 && band1>0) {
           H2+=HH2;
           H3+=HH3;
           fhi0[i]=H2;
           flo0[i]=H3;
         }
         if (bands>0 && band2>0) {
           H4+=HH4;
           H5+=HH5;
           phi0[i]=H4;
           plo0[i]=H5;
         }
       }
     } 
   }
   if (showf>0) {
     limit=iBarShift(NULL,0,iTime(NULL,timeframe,nobs-1));
     SetIndexDrawBegin(3,limit);
     if (future>0) {
       V=Period();
       V/=timeframe;
       for (bar=0; bar<future; bar++)
         hpf0[bar]=newt(hpf,0,(future-bar)*V); 
     }
     for (bar=nobs-1; bar>=0; bar--) {
       if (bar==0)
         disp=future;
       else if (timeframe<=Period())
         disp=iBarShift(NULL,0,iTime(NULL,timeframe,bar))+future;
       else  
         disp=iBarShift(NULL,0,iTime(NULL,timeframe,bar-1))+future+1;
       hpf0[disp]=hpf[bar];
       if (bar<nobs-1) {
         limit=iBarShift(NULL,0,iTime(NULL,timeframe,bar+1))+future;
         i=limit-disp;
         if (i<2) continue;
         H1=hpf[bar];
         HH1=(H1-hpf[bar+1])/i;
         for (i=limit-1; i>disp; i--) {
           H1+=HH1;
           hpf0[i]=H1;
         }  
       }  
     }  
   }
   if (bands>0 && band1<0) {
     limit=iBarShift(NULL,0,iTime(NULL,timeframe,nobs-1));
     for (bar=nobs-1; bar>=0; bar--) {
       if (bar==0)
         disp=0;
       else if (timeframe<=Period())
         disp=iBarShift(NULL,0,iTime(NULL,timeframe,bar));
       else  
         disp=iBarShift(NULL,0,iTime(NULL,timeframe,bar-1))+1;
       fhi0[disp]=fhi[bar];
       flo0[disp]=flo[bar];
       if (bar<nobs-1) {
         if (timeframe<=Period())
           limit=iBarShift(NULL,0,iTime(NULL,timeframe,bar+1));
         else  
           limit=iBarShift(NULL,0,iTime(NULL,timeframe,bar))+1;
         i=limit-disp;
         if (i<2) continue;
         H2=fhi[bar+1];
         HH2=(fhi[bar]-H2)/i;
         H3=flo[bar+1];
         HH3=(flo[bar]-H3)/i;
         for (i=limit-1; i>disp; i--) {
           H2+=HH2;
           H3+=HH3;
           fhi0[i]=H2;
           flo0[i]=H3;
         }  
       }  
     }  
   }
   if (bands>0 && band2<0) {
     limit=iBarShift(NULL,0,iTime(NULL,timeframe,nobs-1));
     for (bar=nobs-1; bar>=0; bar--) {
       if (bar==0)
         disp=0;
       else if (timeframe<=Period())
         disp=iBarShift(NULL,0,iTime(NULL,timeframe,bar));
       else  
         disp=iBarShift(NULL,0,iTime(NULL,timeframe,bar-1))+1;
       phi0[disp]=phi[bar];
       plo0[disp]=plo[bar];
       if (bar<nobs-1) {
         if (timeframe<=Period())
           limit=iBarShift(NULL,0,iTime(NULL,timeframe,bar+1));
         else  
           limit=iBarShift(NULL,0,iTime(NULL,timeframe,bar))+1;
         i=limit-disp;
         if (i<2) continue;
         H4=phi[bar+1];
         HH4=(phi[bar]-H4)/i;
         H5=plo[bar+1];
         HH5=(plo[bar]-H5)/i;
         for (i=limit-1; i>disp; i--) {
           H4+=HH4;
           H5+=HH5;
           phi0[i]=H4;
           plo0[i]=H5;
         }  
       }  
     }  
   }

   
   return(0);
}

void MyAlert(string alert) {
  static string last;
  if (alert==last) return;
  last=alert; 
  // if (alerts) Alert(IND+tframe+alert);
  passos = passos + (IND+tframe+alert);
  //if (audio!="") PlaySound(audio);
}

void DrawArrow(string objectName, datetime Time1, double Price, int ArrowCode, color Color, int Width )   
{
   ObjectCreate(objectName, OBJ_ARROW, 0, Time1, Price, 0);
   ObjectSet(objectName, OBJPROP_ARROWCODE, ArrowCode );
   ObjectSet(objectName, OBJPROP_COLOR, Color);
   ObjectSet(objectName, OBJPROP_RAY, true);
   ObjectSet(objectName, OBJPROP_WIDTH, Width);
   ObjectMove(objectName, 0, Time1, Price);
}

void DrawText(string objectName,string texto, datetime Time1, double Price, int ArrowCode, color Color, int Width )   
{
   ObjectCreate(objectName, OBJ_TEXT, 0, Time1, Price, 0);
   ObjectSet(objectName, OBJPROP_COLOR, Color);
   ObjectSet(objectName, OBJPROP_RAY, true);
   ObjectSet(objectName, OBJPROP_WIDTH, Width);
   ObjectSetText(objectName,texto,8,"Tahoma",textColor);   
   ObjectMove(objectName, 0, Time1, Price);
}


double newt(double x[], int pos, double n) {
  double r=x[pos],k=1;
  int l=MathCeil(n), i;
  if (pos+l>=ArraySize(x)) l=ArraySize(x)-pos-1;
  if (n==0) return(r);
  if (n<0) return(EMPTY_VALUE);
  for (i=1; i<=l; i++) {
    k*=n/i;
    r+=k*dlt(x,pos,i);
  }
  return(r);
}

double dlt(double x[], int pos, int d) {
  double r=0;
  int i, k=1, pod=pos+d, l=d>>1;
  if (pos>=ArraySize(x)) return(EMPTY_VALUE);
  if (pos+d>=ArraySize(x)) return(0);
  if (d%2>0)
    for (i=0; i<=l; i++, pos++, pod--) {
      r+=k*(x[pos]-x[pod]);
      k*=i-d;
      k/=i+1;
    }
  else {
    for (i=0; i<l; i++, pos++, pod--) {
      r+=k*(x[pos]+x[pod]);
      k*=i-d;
      k/=i+1;
    }
    r+=k*x[pos];
  }  
  return(r);
}



void Cancela(int CONTA, int Endereco)
{
             // CANC1 CANCELA POR INDECISAO.
int ticket = 0;
           if (Endereco != 0)
           {
              for(int i=0;i<OrdersTotal();i++)
              {      
                  if (OrderSelect(i,SELECT_BY_POS))
                  {
                        if(OrderSymbol()==Symbol())  // if (!isOurOrder(OrderTicket()))
                        {
                           if ((OrderComment() == Symbol()+"CR-"+Endereco))
                           {
                               ticket = OrderTicket();
                               //Alert("Pr Acionado N:"+Endereco+" Tick:"+ticket);
                           }//if ((OrderComment() == cont) && (OrderType() == sentido))
                        }// if(OrderSymbol()==Symbol())  // if (!isOurOrder(OrderTicket()))
                  } //if (OrderSelect(i,SELECT_BY_POS))
              }// for(int i=0;i<OrdersTotal();i++)
              if (ticket == 0) return(0);                      
           }// if (Endereco != 0)

                 acao = data+"-"+Symbol() + " - " + "STOP executado";   

                  try = 0;
                  Print("zx1: Cancela por excesso de tentativas");
                  GlobalVariableSet("Sinal_Compra",3);
                  GlobalVariableSet("Valor",Ask);
                  GlobalVariableSet("Ticket",ticket);
                  GlobalVariableSet("StopLoss",0);
                  GlobalVariableSet("Papel",cod_papel(Symbol())); // Codpapel             
                  GlobalVariableSet("QT",QT);
                  GlobalVariableSet("Conta",CONTA);                                                 
                  GlobalVariableSet("codigo",1616);              
                  GlobalVariableSet("Comentario",CONTA);                  
                  compra_hora = Time[0];  

           if(CONTA == 1) 
           {
             gat10 = false;
             gat50 = false;
             gat100 = false;
           }
          caixa = caixa + ganho1;
            
            int simb = cod_papel(Symbol());            
            Tickets[CONTA-1][OrderTicketV] = 0;
            Tickets[CONTA-1][OrderTypeV] = 0;
            Tickets[CONTA-1][OrderLotsV] = 0;
            Tickets[CONTA-1][OrderOpenPriceV] = 0;
            Tickets[CONTA-1][OrderOpenTimeV] = 0;         
            Tickets[CONTA-1][OrderSymbolV] = 0;       
            TicketsC[CONTA-1] = 0;  
            L_cod_operacao = 0;  
            
}    

bool Op_Modifica(double Origem, int conta, int ticket,double valor) // 1 - LA , 2 - LB, 3 - CR
{
if (ticket == 0)
{

     if ((ObjectFind("STLF") == 0) && (Tickets[conta-1][OrderLotsV] > 0))
     {
           Print("Acionado por => " + cod_operacao );
           GlobalVariableSet("Sinal_Compra",4);
           GlobalVariableSet("Valor",ObjectGet("STLF",OBJPROP_PRICE1));
           GlobalVariableSet("StopLoss",stopLoss);          
           
           GlobalVariableSet("ticket",ticket);          
           GlobalVariableSet("Papel",cod_papel(Symbol()));               
           GlobalVariableSet("QT",0);
           GlobalVariableSet("Comentario",conta);
           GlobalVariableSet("codigo",Origem);                                 
     }  
} else
{
           if (GlobalVariableGet("Papel") == 0)
           {
           if(OrderSelect(ticket, SELECT_BY_TICKET)==true)
           { 
              if ((NormalizeDouble(OrderTakeProfit(),digits_corretora) != NormalizeDouble(valor,digits_corretora)) && (NormalizeDouble(OrderStopLoss(),digits_corretora) != NormalizeDouble(valor,digits_corretora)))
              {                
                //acao = data+"-"+Symbol() + " - " + "Modificao em execuo - Origen:"+ Origem;
                if (ticket != 0)
                {
                Print("Acionado por => " + cod_operacao );
                GlobalVariableSet("Sinal_Compra",4);
                GlobalVariableSet("Valor",valor);
                GlobalVariableSet("StopLoss",stopLoss);          
           
                GlobalVariableSet("ticket",ticket);          
                GlobalVariableSet("Papel",cod_papel(Symbol()));               
                GlobalVariableSet("QT",0);
                GlobalVariableSet("Comentario",conta);
                GlobalVariableSet("codigo",Origem);                      
                }
              }
           } else
           {
             if(GetLastError() > 5)
             GlobalVariableSet("TICK_ERROR",ticket); 
           }
           
           } else
           {
               if (ticket != 0)
               if(OrderSelect(ticket, SELECT_BY_TICKET)==false)
               ObjectDelete(L_OBJECT);
           }
}
     cod_operacao = 0;
}


bool Op_Compra(double Origem, int conta, double Quant, int Endereco) // 1 - LA , 2 - LB, 3 - CR
{
           //if ((Aguardar() == true)  || (Tickets[conta-1][OrderTypeV] != OP_BUY) )
           { 
           if (Endereco != 0)
           {
              for(int i=0;i<OrdersTotal();i++)
              {      
                  if (OrderSelect(i,SELECT_BY_POS))
                  {
                        if(OrderSymbol()==Symbol())  // if (!isOurOrder(OrderTicket()))
                        {
                           if ((OrderComment() == Symbol()+"CR-"+Endereco))
                           {
                               return(0); 
                           }//if ((OrderComment() == cont) && (OrderType() == sentido))
                        }// if(OrderSymbol()==Symbol())  // if (!isOurOrder(OrderTicket()))
                  } //if (OrderSelect(i,SELECT_BY_POS))
              }// for(int i=0;i<OrdersTotal();i++)                      
           }// if (Endereco != 0)
                                  
           Print("Acionado por => " + cod_operacao );
           PlaySound("alert.wav");        
           GlobalVariableSet("Sinal_Compra",1);
           GlobalVariableSet("Valor",Ask);
           GlobalVariableSet("StopLoss",stopLoss);          
           GlobalVariableSet("Papel",cod_papel(Symbol()));               
           GlobalVariableSet("QT",Quant);
           GlobalVariableSet("Comentario",conta);
           GlobalVariableSet("Endereco",Endereco);
           GlobalVariableSet("codigo",Origem);           
           compra_hora = Time[0];
           L_cod_operacao = cod_operacao;
           caixa = caixa + ganho1;
           L_ganho = L_ganho + ganho0; 
           gatilho_abertura = 0;
           Duvida = false;
           gatilho[conta-1]= 0;           
           
           acao = data+"-"+Symbol() + " - " + "Compra executada";
            /////////////////////////////////
            // Registrando dados na Matriz           
            /////////////////////////////////
           if(conta == 1) 
           {
             gat10 = false;
             gat50 = false;
             gat100 = false;
           }
                      
      
            Tickets[conta-1][OrderTicketV] = 220;
            Tickets[conta-1][OrderTypeV] = OP_BUY;
            Tickets[conta-1][OrderLotsV] = QT;
            Tickets[conta-1][OrderOpenPriceV] = Close[0];
            Tickets[conta-1][OrderOpenTimeV] = Time[0];         
            Tickets[conta-1][OrderSymbolV] = cod_papel(Symbol());       
            Tickets[conta-1][DirecaoSolicitada] = 1; // BUY       
            Tickets[conta-1][Cod_Conta] = conta; // BUY       
            TicketsC[conta-1] = Conta(conta);
            
                                     
           ordem_enviada = "Coreo Venda : "+Symbol();                          
           num_oper_hora = num_oper_hora + 1;
           cod_operacao = 0;
           ganho0 = 0;
           ganho2 = 0;
         }  
}


bool Op_Venda(double Origem, int conta, double Quant, int Endereco) // 1 - LA , 2 - LB, 3 - CR
{
if ((NUM_CONTA >= 4) || (NUM_CONTA == 0)) NUM_CONTA = 1;

     //if (AlertDelay(30) && ((Aguardar() == true)))
         //if ((Aguardar() == true) || (Tickets[conta-1][OrderTypeV] != OP_SELL) )
         { 
           Print("Acionado por => " + cod_operacao );           
           PlaySound("alert.wav");        
           if (Endereco != 0)
           {
              for(int i=0;i<OrdersTotal();i++)
              {      
                  if (OrderSelect(i,SELECT_BY_POS))
                  {
                        if(OrderSymbol()==Symbol())  // if (!isOurOrder(OrderTicket()))
                        {
                           if ((OrderComment() == Symbol()+"CR-"+Endereco))
                           {
                               return(0); 
                           }//if ((OrderComment() == cont) && (OrderType() == sentido))
                        }// if(OrderSymbol()==Symbol())  // if (!isOurOrder(OrderTicket()))
                  } //if (OrderSelect(i,SELECT_BY_POS))
              }// for(int i=0;i<OrdersTotal();i++)                      
           }// if (Endereco != 0)
                    
           GlobalVariableSet("Sinal_Compra",2);
           GlobalVariableSet("Valor",Ask);
           GlobalVariableSet("StopLoss",stopLoss);
           GlobalVariableSet("Papel",cod_papel(Symbol()));             
           GlobalVariableSet("QT",Quant);
           GlobalVariableSet("Comentario",conta);           
           GlobalVariableSet("codigo",Origem);
           GlobalVariableSet("Endereco",Endereco);
           compra_hora = Time[0];
           L_cod_operacao = cod_operacao;
           caixa = caixa + ganho1;
           L_ganho = L_ganho + ganho0;           
           cod_operacao = 0;
           gatilho[conta-1]= 0;
           gatilho_abertura = 0;
           Duvida = false;
           if(conta == 1) 
           {
             gat10 = false;
             gat50 = false;
             gat100 = false;
           }
            /////////////////////////////////
            // Registrando dados na Matriz           
            /////////////////////////////////                      
            acao = data+"-"+Symbol() + " - " + "Venda executada";

            Tickets[conta-1][OrderTicketV] = 219;
            Tickets[conta-1][OrderTypeV] = OP_SELL;
            Tickets[conta-1][OrderLotsV] = QT;
            Tickets[conta-1][OrderOpenPriceV] = Close[0];
            Tickets[conta-1][OrderOpenTimeV] = Time[0];         
            Tickets[conta-1][OrderSymbolV] = cod_papel(Symbol());       
            Tickets[conta-1][DirecaoSolicitada] = 2; // SELL       
            Tickets[conta-1][Cod_Conta] = conta; // BUY       
            TicketsC[conta-1] = Conta(conta);
           
           ganho0 = 0;
           ganho2 = 0;
           ordem_enviada = "Coreo Venda : "+Symbol();                          
           num_oper_hora = num_oper_hora + 1;
         }
}

///////////////////

bool Aguardar()
{
bool resp = (GlobalVariableGet("Papel") == 0);
return(resp);
}

////////////////

/////////////////////////////////////////////////
//  MTVINI
/////////////////////////////////////////////////
///////////////
double MTDelete()
{
if (MTTotal() > 0)
{
 int countt = 0;
 for (int ii=0; ii <= MTTotal(); ii++)
 {
 if (ii != VMTPosicao)
 {
         mem_Tickets[ii][0] = Tickets[ii][0];
         mem_Tickets[ii][1] = Tickets[ii][1];
         mem_Tickets[ii][2] = Tickets[ii][2];
         mem_Tickets[ii][3] = Tickets[ii][3];
         mem_Tickets[ii][4] = Tickets[ii][4];
         mem_Tickets[ii][5] = Tickets[ii][5];
         mem_Tickets[ii][6] = Tickets[ii][6];
         mem_Tickets[ii][7] = Tickets[ii][7];
         mem_Tickets[ii][8] = Tickets[ii][8];         
         mem_Tickets[ii][9] = Tickets[ii][9]; 
         mem_TicketsC[ii]   = TicketsC[ii];
         countt = countt + 1;         
 }         
 }

ArrayCopy(Tickets,mem_Tickets,0,0,countt);

 MTAnterior();
}
}

double MTFinde(double VPapel,double VTipo)
{
if (MTTotal() > 0)
{
 int countt = 0;
 for (int ii=0; ii <= MTTotal(); ii++)
 {
   if ((VPapel == Tickets[ii][9]) && (VTipo == Tickets[ii][1]))
   {
     return(true); 
   }
 }
}
return(false);
}



///////////////
double MTInsert()
{
  ArrayResize(Tickets,MTTotal()+1);
  VMTPosicao = ArrayRange(Tickets,0)-1;
  VMTPosicao = 0;
 return(VMTPosicao);
}
///////////////
double MTLeitura(int Comando)
{
  return(Tickets[NUM_CONTA][Comando]);
}
///////////////
double MTAnterior()
{
  VMTPosicao = VMTPosicao - 1;
  return(VMTPosicao);
}
///////
double MTTotal()
{
  return(ArrayRange(Tickets,0));
}
///////

int cod_papel(string nome)
{
double valor;
           if (nome == "EURUSD") valor = 1; // (1) EURUSD
           if (nome == "USDCHF") valor = 2; // (1) EURUSD
           if (nome == "CHFJPY") valor = 3; // (1) EURUSD
           if (nome == "GBPUSD") valor = 4; // (1) EURUSD
           if (nome == "EURJPY") valor = 5; // (1) EURUSD
           if (nome == "AUDUSD") valor = 6; // (1) EURUSD
           if (nome == "NZDUSD") valor = 7; // (1) EURUSD
           if (nome == "EURCHF") valor = 8; // (1) EURUSD
           if (nome == "CADJPY") valor = 9; // (1) EURUSD
           if (nome == "USDCAD") valor = 10; // (1) EURUSD
           if (nome == "USDJPY") valor = 11; // (1) EURUSD
           if (nome == "AUDNZD") valor = 12; // (1) EURUSD
           if (nome == "AUDCAD") valor = 13; // (1) EURUSD        
           if (nome == "AUDCHF") valor = 14; // (1) EURUSD                
           if (nome == "EURNZD") valor = 15; // (1) EURUSD                
           if (nome == "EURCAD") valor = 16; // (1) EURUSD  
           if (nome == "GOLD")   valor = 17; // (1) EURUSD  
           if (nome == "SILVER") valor = 18; // (1) EURUSD  
           if (nome == "GBPCAD") valor = 19; // (1) EURUSD
   return(valor);
}

string Conta(int Cod_Conta)
{
string coment;
if(Cod_Conta == 1) coment = (Symbol()+"CR");
if(Cod_Conta == 2) coment = (Symbol()+"LA");
if(Cod_Conta == 3) coment = (Symbol()+"LB");
return(coment);
}


string stochV()
{
int    counted_bars=IndicatorCounted();
int Stoch_K = 5;   
int Stoch_D = 2;
int Stoch_Slowing = 2;
int Stoch_Method = MODE_SMA;
int Stoch_PriceField = 0; // Price field parameter. Can be one of this values: 0 - Low/High or 1 - Close/Close. 
string vsinal = "";
//----
double stoch = iStochastic(Symbol(), 0, Stoch_K, Stoch_D, Stoch_Slowing, Stoch_Method, Stoch_PriceField, MODE_MAIN, 0);
double stoch_sig = iStochastic(Symbol(), 0, Stoch_K, Stoch_D, Stoch_Slowing, Stoch_Method, Stoch_PriceField, MODE_SIGNAL, 0);

if (stoch > stoch_sig) vsinal = "Buy"; 
if (stoch < stoch_sig) vsinal = "Sell";

return (vsinal);
}

//+--------------------------------------------------------------------------------------------------+
//| Custom indicator iteration function                                                              |
//+--------------------------------------------------------------------------------------------------+
int start()
  {
data = TimeDay(Time[0])+"/"+TimeMonth(Time[0])+""+tf()+"-"+TimeHour(Time[0])+":"+TimeMinute(TimeCurrent())  ;

//////////////
// RADAR
/////////////
   
   for(int x=0;x<9;x++)
   {
      if(iMA(Symbol(),period[x],13,0,0,0,0)>iMA(Symbol(),period[x],24,0,0,0,0)) 
      {
         ObjectSetText("signal"+x+"0",CharToStr(symbolCodeBuy),fontSize,"Wingdings",signalBuyColor);
         MMA[x] = 1;
      }
      else
      {
         ObjectSetText("signal"+x+"0",CharToStr(symbolCodeSell),fontSize,"Wingdings",signalSellColor); 
         MMA[x] = 2;
      }
   }
 
   for(x=0;x<9;x++)
   {
      if(MathAbs(iWPR(Symbol(),period[x],5,0))<20.0)
         ObjectSetText("signal"+x+"1",CharToStr(symbolCodeBuy),fontSize,
         "Wingdings",signalBuyColor);   
      else if(MathAbs(iWPR(Symbol(),period[x],Sintonia_Radar2,0))>80.0)
         ObjectSetText("signal"+x+"1",CharToStr(symbolCodeSell),fontSize,
         "Wingdings",signalSellColor);   
      else
         ObjectSetText("signal"+x+"1",CharToStr(symbolCodeNoSignal),fontSize,
         "Wingdings",noSignalColor);      
   }
 
   for(x=0;x<9;x++)
   {
      if(iSAR(Symbol(),period[x],0.02,0.2,0)<Close[0])
         ObjectSetText("signal"+x+"2",CharToStr(symbolCodeBuy),fontSize,
         "Wingdings",signalBuyColor);
      else
         ObjectSetText("signal"+x+"2",CharToStr(symbolCodeSell),fontSize,
         "Wingdings",signalSellColor);
   }

int risk_evol = 0;

  if (OrdersTotal() != 0)
    {
        for(int i=0;i<OrdersTotal();i++)
        {      
          if (OrderSelect(i,SELECT_BY_POS))
          {
            if(OrderSymbol() == Symbol())
            {
            // buy
            if (OrderType() == 0)
            {
            risk_evol = 0;
               for (x = 0; x < 9; x++)
               {
                  if (x < 6) int pnt = 10;
                  else pnt = 20;
                  risk_evol = risk_evol + (MMA[x] * pnt*1);                     
               } // for (x = 0; x < 9; x++)                     
                   risk_evol = risk_evol - 195;
                   int simbulo = 241;                   
                   int cor = 0;
                   if ((risk_evol > 15) && (risk_evol < 28)) cor = Yellow;
                   if (risk_evol < 0)  cor = Red;
                   if (((risk_evol >= 0) && (risk_evol < 9)) && (OrderOpenPrice() > Close[0])) {cor = Red; simbulo = 251;}
                   if (risk_evol > 28) cor = Green;
                    DrawArrow("TickerS-"+OrderTicket(),  (Time[0]+100), (Close[0] + (i*0.04)), simbulo, cor, 3);               
                    DrawText("TickerT-"+OrderTicket(), "Risk:"+risk_evol, (Time[0]+170), (Close[0] + (i*0.04)), 241, cor, 3);               
            } //(OrderType == 0)
            // sell
            if (OrderType() == 1)
            {
            risk_evol = 0;
               for (x = 0; x < 9; x++)
               {
                  if (x < 6) pnt = 10;
                  else pnt = 20;
                  risk_evol = risk_evol + (MMA[x] * pnt * 2 );                     
               } // for (x = 0; x < 9; x++)                       
                   risk_evol = (risk_evol - 195) / 3;
                   simbulo = 242;
                   if (risk_evol > 0) cor = 100100;
                   if ((risk_evol > 15) && (risk_evol < 28)) cor = Yellow;
                   if (risk_evol < 22) cor = Red;
                   if ((risk_evol == 55) && (OrderOpenPrice() < Close[0])) {cor = Yellow; simbulo = 73;}
                   if ((risk_evol == 21) && (OrderOpenPrice() < Close[0])) {cor = Red; simbulo = 73;}

                 DrawArrow("Ticker-"+OrderTicket(),  (Time[0]+100), (Close[0] + (i*0.04)), simbulo, cor, 3);               
                 DrawText("TickerT-"+OrderTicket(), "Risk:"+(risk_evol), (Time[0]+170), (Close[0] + (i*0.04)), 241, 200, 3);               
            } //(OrderType == 0)
          } // if(OrderSymbol() == Symbol())
        } // if (OrderSelect(i,SELECT_BY_POS))
     } // for(int i=0;i<OrdersTotal();i++)
  } // if (OrdersTotal() != 0)
risk_evol = risk_evol - 210;
////////

Carregamento();
         
  NUM_CONTA = NUM_CONTA + 1;
  if (NUM_CONTA >= 4) NUM_CONTA = 1; 
   
   datapoints=dp_limiter;
   pos=endpos+datapoints-1;
   PolynomialRegression(1);
   errorstddev[0]=StdDevRegError();
   PolynomialRegression(2);
   errorstddev[1]=StdDevRegError();
   LogarithmicRegression();
   errorstddev[2]=StdDevRegError();
   ExponentialRegression();
   errorstddev[3]=StdDevRegError();
   
   if(record)
      if(c_handle>0)
         FileWrite(c_handle,StringConcatenate(TimeHour(TimeCurrent()),":",TimeMinute(TimeCurrent()),":",TimeSeconds(TimeCurrent())),errorstddev[0],errorstddev[1],errorstddev[2],errorstddev[3]);
   
   grafista();
   BestReg();
   ConfidenceBands();
   


if (decimais_multiplo == 0 ) decimais_multiplo = 1;
/////////////////////////////
// METRICA CONTA 1
////////////////////////////
      NUM_CONTA = 1;
      double compra = Tickets[0][OrderOpenPriceV];
      double tipo   = Tickets[0][OrderTypeV];
      double lot    = Tickets[0][OrderLotsV];    
      double equal  = -MathPow((10), Digits);
       if (tipo == OP_BUY) // BUY
       { 
       if (decimais_multiplo > 0)
           ganho0 = (-((((Close[0]-compra))*equal)*lot))*decimais_multiplo; // *2
       if (decimais_multiplo < 0)
           ganho0 = (-((((Close[0]-compra))*equal)*lot))/(-decimais_multiplo); // *2
       }       
       if (tipo == OP_SELL) // SELL
       { 
       if (decimais_multiplo > 0)
           ganho0 = (((((Close[0]-compra))*equal)*lot))*decimais_multiplo; // *2
       if (decimais_multiplo < 0)
           ganho0 = (((((Close[0]-compra))*equal)*lot))/(-decimais_multiplo); // *2
       }

        int fator = Ask - Bid;          
        ganho0 = ganho0 + (fator*2);
        ganho1 = ganho0;
       
/////////////////////////////
// METRICA CONTA 2
////////////////////////////
      NUM_CONTA = 2;
       compra = Tickets[1][OrderOpenPriceV];
       tipo   = Tickets[1][OrderTypeV];
       lot    = Tickets[1][OrderLotsV]; 
       equal  = -MathPow((10), Digits);
       if (tipo == OP_BUY) // BUY
       { 
       if (decimais_multiplo > 0)
           ganho0 = (-((((Close[0]-compra))*equal)*lot))*decimais_multiplo; // *2
       if (decimais_multiplo < 0)
           ganho0 = (-((((Close[0]-compra))*equal)*lot))/(-decimais_multiplo); // *2
       }       
       if (tipo == OP_SELL) // SELL
       { 
       if (decimais_multiplo > 0)
           ganho0 = (((((Close[0]-compra))*equal)*lot))*decimais_multiplo; // *2
       if (decimais_multiplo < 0)
           ganho0 = (((((Close[0]-compra))*equal)*lot))/(-decimais_multiplo); // *2
       }

         fator = Ask - Bid;          
        ganho0 = ganho0 + (fator*2);
        ganho2 = ganho0;
/////////////////////////////
// METRICA CONTA 3
////////////////////////////
      NUM_CONTA = 3;
       compra = Tickets[2][OrderOpenPriceV];
       tipo   = Tickets[2][OrderTypeV];
       lot    = Tickets[2][OrderLotsV];  
       equal  = -MathPow((10), Digits);
       if (tipo == OP_BUY) // BUY
       { 
       if (decimais_multiplo > 0)
           ganho0 = (-((((Close[0]-compra))*equal)*lot))*decimais_multiplo; // *2
       if (decimais_multiplo < 0)
           ganho0 = (-((((Close[0]-compra))*equal)*lot))/(-decimais_multiplo); // *2
       }       
       if (tipo == OP_SELL) // SELL
       { 
       if (decimais_multiplo > 0)
           ganho0 = (((((Close[0]-compra))*equal)*lot))*decimais_multiplo; // *2
       if (decimais_multiplo < 0)
           ganho0 = (((((Close[0]-compra))*equal)*lot))/(-decimais_multiplo); // *2
       }

        fator = Ask - Bid;          
        ganho0 = ganho0 + (fator*2);
        ganho3 = ganho0;

passos = passos +" "+LF+"LC$: "+DoubleToStr(ganho1,2)+ " - "+LA+"LA$: "+DoubleToStr(ganho2,2) + " - "+LB+"LB$: "+DoubleToStr(ganho3,2)+" - "+" G1:"+gat10+" G2:"+gat50+" G3:"+gat100;
passos = passos + " Lam: "+ lambda;

//////////////
// MANEY MANEGER;
/////////////
 double caixabalance = caixa;
// REAL caixabalance = AccountBalance();
if (MONEY_MANEGER == true)
{
  if (M_1 > caixabalance)   
  { QT = 0.1; QT_spread = 0.01;}
  if (M_2 < caixabalance)   
  { QT = 0.2; QT_spread = 0.02;}
  if (M_3 < caixabalance)   
  { QT = 0.3; QT_spread = 0.03;}
  if (M_4 < caixabalance)   
  { QT = 0.4; QT_spread = 0.04;}
  if (M_5 < caixabalance)  
  { QT = 0.5; QT_spread = 0.05;}
  if (M_6 < caixabalance)
  { QT = 0.6; QT_spread = 0.06;}
  if (M_7 < caixabalance)   
  { QT = 0.7; QT_spread = 0.07;}
  if (M_8 < caixabalance) 
  { QT = 0.8; QT_spread = 0.08;}
  if (M_9 < caixabalance)
  { QT = 0.9; QT_spread = 0.09;}
  if (M_10 < caixabalance) 
  { QT = 1.0; QT_spread = 0.10;}
} 



int val_cnt = 350;
int val_u  = 250;
int val_d  = 250;
/////////////////////
// LB / LA BORDAS
/////////////////////

/////////////////////
// novo gerenciador
////////////////////

////////////////////////////
// duvida
////////////////////////////


////////////////////////////
// correcao
////////////////////////////


/////////////////////////////
// linha desdobramento.
////////////////////////////


/////////////////////////////
// gatilho
////////////////////////////

  
/////////////////////////////
// Placar
////////////////////////////


/////////////////////////////
// INTERATIVIDADE EM LINHA STLA, STLB, PRLA, PRLB
////////////////////////////

for (int zz = 0; zz < 1000; zz ++)  
{
     if (ObjectFind("BUYLFCNT"+zz) == 0) 
     {
         spread = 1;
         debug = debug + ("BUYLFCNT LF AT "+ObjectGet("BUYLFCNT"+zz,OBJPROP_PRICE1 )+"\n");
         ObjectSet("BUYLFCNT"+zz,OBJPROP_WIDTH,2);
         ObjectSet("BUYLFCNT"+zz,OBJPROP_COLOR,MintCream);
         ObjectSet("BUYLFCNT"+zz,OBJPROP_STYLE,STYLE_SOLID);         
         if ((ObjectGet("BUYLFCNT"+zz,OBJPROP_PRICE1 )) < (Close[0])) {cod_operacao = 9998; } // C         
     }
     if (ObjectFind("SELLLFCNT"+zz) == 0)
     {
         spread = 1;
         debug = debug + ("SELL LF AT "+ObjectGet("SELLLFCNT"+zz,OBJPROP_PRICE1 )+"\n");
         ObjectSet("SELLLFCNT"+zz,OBJPROP_WIDTH,2);
         ObjectSet("SELLLFCNT"+zz,OBJPROP_COLOR,MintCream);
         ObjectSet("SELLLFCNT"+zz,OBJPROP_STYLE,STYLE_SOLID);         
         if ((ObjectGet("SELLLFCNT"+zz,OBJPROP_PRICE1 )) > (Close[0])) { cod_operacao = 9999; }         
     }
}


     if ((ObjectFind("BUYLACNT") == 0) && (Tickets[1][OrderOpenPriceV] == 0))
     {
         debug = debug + ("BUYLACNT LA AT "+ObjectGet("BUYLACNT",OBJPROP_PRICE1 )+"\n");
         ObjectSet("BUYLACNT",OBJPROP_WIDTH,2);
         ObjectSet("BUYLACNT",OBJPROP_COLOR,MintCream);
         ObjectSet("BUYLACNT",OBJPROP_STYLE,STYLE_SOLID);         
         if ((ObjectGet("BUYLACNT",OBJPROP_PRICE1 )) < (Close[0])) {cod_operacao = 1150; ObjectDelete("BUYLACNT");} // C         
     }
     if ((ObjectFind("SELLLACNT") == 0) && (Tickets[1][OrderOpenPriceV] == 0))
     {
         debug = debug + ("SELL LA AT "+ObjectGet("SELLLACNT",OBJPROP_PRICE1 )+"\n");
         ObjectSet("SELLLACNT",OBJPROP_WIDTH,2);
         ObjectSet("SELLLACNT",OBJPROP_COLOR,MintCream);
         ObjectSet("SELLLACNT",OBJPROP_STYLE,STYLE_SOLID);         
         if ((ObjectGet("SELLLACNT",OBJPROP_PRICE1 )) > (Close[0])) { cod_operacao = 1151; ObjectDelete("SELLLACNT");}         
     }
     if ((ObjectFind("BUYLBCNT") == 0) && (Tickets[2][OrderOpenPriceV] == 0))
     {
         debug = debug + ("BUY LB AT "+ObjectGet("BUYLBCNT",OBJPROP_PRICE1 )+"\n");
         ObjectSet("BUYLBCNT",OBJPROP_WIDTH,2);
         ObjectSet("BUYLBCNT",OBJPROP_COLOR,MintCream);
         ObjectSet("BUYLBCNT",OBJPROP_STYLE,STYLE_SOLID);         
         if ((ObjectGet("BUYLBCNT",OBJPROP_PRICE1 )) < (Close[0])) { cod_operacao = 888; ObjectDelete("BUYLBCNT"); } // C 
         
     }
     if ((ObjectFind("SELLLBCNT") == 0) && (Tickets[2][OrderOpenPriceV] == 0))
     {
         debug = debug + ("SELL LA AT "+ObjectGet("SELLLBCNT",OBJPROP_PRICE1 )+"\n");
         ObjectSet("SELLLBCNT",OBJPROP_WIDTH,2);
         ObjectSet("SELLLBCNT",OBJPROP_COLOR,MintCream);
         ObjectSet("SELLLBCNT",OBJPROP_STYLE,STYLE_SOLID);         
         if ((ObjectGet("SELLLBCNT",OBJPROP_PRICE1 )) > (Close[0])) { cod_operacao = 999; ObjectDelete("SELLLBCNT");}// V                  
     }     
      
     ///////////////////
for ( zz = 0; zz < 100; zz ++)  
{
     if (ObjectFind("BUYLF"+zz) == 0) 
     {
         spread = 0;
         debug = debug + ("BUY LF AT "+ObjectGet("BUYLF"+zz,OBJPROP_PRICE1 )+"\n");
         ObjectSet("BUYLF"+zz,OBJPROP_WIDTH,2);
         ObjectSet("BUYLF"+zz,OBJPROP_COLOR,MintCream);
         ObjectSet("BUYLF"+zz,OBJPROP_STYLE,STYLE_SOLID);         
         if ((ObjectGet("BUYLF"+zz,OBJPROP_PRICE1 )) > (Close[0])) {cod_operacao = 444; ObjectDelete("BUYLF"+zz);} // C
         
     }
     if (ObjectFind("SELLLF"+zz) == 0) 
     {
         spread = 0;
         debug = debug + ("SELL LA AT "+ObjectGet("SELLLF"+zz,OBJPROP_PRICE1 )+"\n");
         ObjectSet("SELLLF"+zz,OBJPROP_WIDTH,2);
         ObjectSet("SELLLF"+zz,OBJPROP_COLOR,MintCream);
         ObjectSet("SELLLF"+zz,OBJPROP_STYLE,STYLE_SOLID);         
         if ((ObjectGet("SELLLF"+zz,OBJPROP_PRICE1 )) < (Close[0])) { cod_operacao = 555; ObjectDelete("SELLLF"+zz);}        
     }     
}
     
     if ((ObjectFind("BUYLA") == 0) && (Tickets[1][OrderOpenPriceV] == 0))
     {
         debug = debug + ("BUY LA AT "+ObjectGet("BUYLA",OBJPROP_PRICE1 )+"\n");
         ObjectSet("BUYLA",OBJPROP_WIDTH,2);
         ObjectSet("BUYLA",OBJPROP_COLOR,MintCream);
         ObjectSet("BUYLA",OBJPROP_STYLE,STYLE_SOLID);         
         if ((ObjectGet("BUYLA",OBJPROP_PRICE1 )) > (Close[0])) {cod_operacao = 1150; ObjectDelete("BUYLA");} // C
         
     }
     if ((ObjectFind("SELLLA") == 0) && (Tickets[1][OrderOpenPriceV] == 0))
     {
         debug = debug + ("SELL LA AT "+ObjectGet("SELLLA",OBJPROP_PRICE1 )+"\n");
         ObjectSet("SELLLA",OBJPROP_WIDTH,2);
         ObjectSet("SELLLA",OBJPROP_COLOR,MintCream);
         ObjectSet("SELLLA",OBJPROP_STYLE,STYLE_SOLID);         
         if ((ObjectGet("SELLLA",OBJPROP_PRICE1 )) < (Close[0])) { cod_operacao = 1151; ObjectDelete("SELLLA");}
         
     }
     if ((ObjectFind("BUYLB") == 0) && (Tickets[1][OrderOpenPriceV] == 0))
     {
         debug = debug + ("BUY LB AT "+ObjectGet("BUYLB",OBJPROP_PRICE1 )+"\n");
         ObjectSet("BUYLB",OBJPROP_WIDTH,2);
         ObjectSet("BUYLB",OBJPROP_COLOR,MintCream);
         ObjectSet("BUYLB",OBJPROP_STYLE,STYLE_SOLID);         
         if ((ObjectGet("BUYLB",OBJPROP_PRICE1 )) > (Close[0])) {cod_operacao = 1150; ObjectDelete("BUYLB");} // C
         
     }
     if ((ObjectFind("SELLLB") == 0) && (Tickets[1][OrderOpenPriceV] == 0))
     {
         debug = debug + ("SELL LB AT "+ObjectGet("SELLLB",OBJPROP_PRICE1 )+"\n");
         ObjectSet("SELLLB",OBJPROP_WIDTH,2);
         ObjectSet("SELLLB",OBJPROP_COLOR,MintCream);
         ObjectSet("SELLLB",OBJPROP_STYLE,STYLE_SOLID);         
         if ((ObjectGet("SELLLB",OBJPROP_PRICE1 )) < (Close[0])) { cod_operacao = 1151; ObjectDelete("SELLLB");}
         
     }

if(cod_operacao == 0)
{
for(i = ObjectsTotal()-1 ; i >=0; i--) 
{

    string obj_name = ObjectName(i);
    string strx = StringSubstr(obj_name,0,6);

     if (strx == "ST_MV-")
     {
         // if the subwindow number is -1, there is an error
         debug = debug + ("MOVE LF AT "+ObjectGet(obj_name,OBJPROP_PRICE1 )+"\n");
         ObjectSet(obj_name,OBJPROP_WIDTH,1);
         ObjectSet(obj_name,OBJPROP_COLOR, Yellow);
         ObjectSet(obj_name,OBJPROP_STYLE,STYLE_DOT);         
         distancia = ObjectGet(obj_name,OBJPROP_PRICE1) - ObjectGet("STLF-"+exp_array[1],OBJPROP_PRICE1 );
         L_OBJECT = obj_name;
         if ((ObjectGet(obj_name,OBJPROP_PRICE1)) < (Close[0]))
         { 
           ObjectSet(obj_name,OBJPROP_PRICE1,Close[0]);
           ObjectSet("STLF-"+exp_array[1],OBJPROP_PRICE1,(Close[0]-distancia));
           //Op_Modifica(10, 1,,0);
         }
         // check error
         if(GlobalVariableGet("TICK_ERROR") != 0)
         if(OrderSelect(DoubleToStr(GlobalVariableGet("TICK_ERROR"),0), SELECT_BY_TICKET)==false)         
         if (DoubleToStr(GlobalVariableGet("TICK_ERROR"),0) == exp_array[1])
         { ObjectDelete(obj_name); DoubleToStr(GlobalVariableSet("TICK_ERROR",0),0);}

     }
     
     obj_name = ObjectName(i);
     strx = StringSubstr(obj_name,0,6);
     if (strx == "PR_MV-")
     {
         Explode(obj_name, "-", exp_array);
         // if the subwindow number is -1, there is an error
         Explode(obj_name, "-", exp_array);
         debug = debug + ("MOVE LF AT "+ObjectGet(obj_name,OBJPROP_PRICE1 )+"\n");
         ObjectSet(obj_name,OBJPROP_WIDTH,1);
         ObjectSet(obj_name,OBJPROP_COLOR, Green);
         ObjectSet(obj_name,OBJPROP_STYLE,STYLE_DOT);         
         distancia = ObjectGet(obj_name,OBJPROP_PRICE1) - ObjectGet("PRLF-"+exp_array[1],OBJPROP_PRICE1 );
         L_OBJECT = obj_name;

         if ((ObjectGet(obj_name,OBJPROP_PRICE1)) > (Close[0]))
         { 
           ObjectSet(obj_name,OBJPROP_PRICE1,Close[0]);
           ObjectSet("PRLF-"+exp_array[1],OBJPROP_PRICE1,(Close[0]-distancia));
           //Op_Modifica(11, 1,0,0);
         }
         // check error
         if(GlobalVariableGet("TICK_ERROR") != 0)
         if(OrderSelect(DoubleToStr(GlobalVariableGet("TICK_ERROR"),0), SELECT_BY_TICKET)==false)         
         if (DoubleToStr(GlobalVariableGet("TICK_ERROR"),0) == exp_array[1])
         { ObjectDelete(obj_name); DoubleToStr(GlobalVariableSet("TICK_ERROR",0),0);}

     }

    if (GlobalVariableGet("Papel") == 0)
    {
    obj_name = ObjectName(i);
    strx = StringSubstr(obj_name,0,5);    
      if (strx == "STLF-")
      {
         Explode(obj_name, "-", exp_array);
         double valor = ObjectGet(obj_name,OBJPROP_PRICE1); 
         ObjectSet(obj_name,OBJPROP_WIDTH,2);
         ObjectSet(obj_name,OBJPROP_COLOR,Blue);
         L_OBJECT = obj_name;
         if(exp_array[1] != "") Op_Modifica(10, 1, StrToInteger(exp_array[1]),valor);         
         // check error
         if(GlobalVariableGet("TICK_ERROR") != 0)
         if(OrderSelect(DoubleToStr(GlobalVariableGet("TICK_ERROR"),0), SELECT_BY_TICKET)==false)         
         if (DoubleToStr(GlobalVariableGet("TICK_ERROR"),0) == exp_array[1])
         { ObjectDelete(obj_name); DoubleToStr(GlobalVariableSet("TICK_ERROR",0),0);}

         
         //ObjectDelete(obj_name);
      }
     }
     
     if (ObjectFind("STLF") == 0)
     {
         // if the subwindow number is -1, there is an error
         debug = debug + ("STOP LF AT "+ObjectGet("STLF",OBJPROP_PRICE1 )+"\n");
         ObjectSet("STLF",OBJPROP_WIDTH,2);
         ObjectSet("STLF",OBJPROP_COLOR,Red);
         ObjectSet("STLF",OBJPROP_STYLE,STYLE_SOLID);         
         if ((Tickets[0][OrderLotsV] > 0) && (ObjectGet("STLF",OBJPROP_PRICE1 )) > (Close[0])){ Cancela(1,0);  ObjectDelete("STLF");ObjectDelete("PR_MV");ObjectDelete("ST_MV");}         
      }



      if (GlobalVariableGet("Papel") == 0)
      {
      obj_name = ObjectName(i);
      strx = StringSubstr(obj_name,0,5);
      if (strx == "PRLF-")
      {
         Explode(obj_name, "-", exp_array);
         valor = ObjectGet(obj_name,OBJPROP_PRICE1); 
         L_OBJECT = obj_name;
         if(exp_array[1] != "") Op_Modifica(11, 1, StrToInteger(exp_array[1]),valor);         
                  // check error
         if(GlobalVariableGet("TICK_ERROR") != 0)
         if(OrderSelect(DoubleToStr(GlobalVariableGet("TICK_ERROR"),0), SELECT_BY_TICKET)==false)         
         if (DoubleToStr(GlobalVariableGet("TICK_ERROR"),0) == exp_array[1])
         { ObjectDelete(obj_name); DoubleToStr(GlobalVariableSet("TICK_ERROR",0),0);}


        // ObjectDelete(obj_name);
      }      
      }
     
     if (ObjectFind("STLF") == 0)
     {
         // if the subwindow number is -1, there is an error
         debug = debug + ("PROFIT LF AT "+ObjectGet("PRLF",OBJPROP_PRICE1 )+"\n");
         ObjectSet("PRLF",OBJPROP_WIDTH,2);
         ObjectSet("PRLF",OBJPROP_COLOR,Green);
         ObjectSet("PRLF",OBJPROP_STYLE,STYLE_SOLID);         
         if ((Tickets[0][OrderLotsV] > 0) && (ObjectGet("PRLF",OBJPROP_PRICE1 )) < (Close[0])) { Cancela(1,0); ObjectDelete("PRLF");ObjectDelete("PR_MV");ObjectDelete("ST_MV");}
      }
      }

}

     if (ObjectFind("STLA") == 0)
      {
         // if the subwindow number is -1, there is an error
         debug = debug + ("STOP LA AT "+ObjectGet("STLA",OBJPROP_PRICE1 )+"\n");
         ObjectSet("STLA",OBJPROP_WIDTH,2);
         ObjectSet("STLA",OBJPROP_COLOR,Red);
         ObjectSet("STLA",OBJPROP_STYLE,STYLE_SOLID);         
         if ((ObjectGet("STLA",OBJPROP_PRICE1 )) > (Close[0])) {Cancela(2,0);ObjectDelete("STLA");}
         
      }
      if (ObjectFind("PRLA") == 0)
      {
         // if the subwindow number is -1, there is an error
         debug = debug + ("PROFIT LA AT : "+ObjectGet("PRLA",OBJPROP_PRICE1 )+"\n");
         ObjectSet("PRLA",OBJPROP_WIDTH,2);
         ObjectSet("PRLA",OBJPROP_COLOR,Green);
         ObjectSet("PRLA",OBJPROP_STYLE,STYLE_SOLID);         
         if ((ObjectGet("PRLA",OBJPROP_PRICE1 )) < (Close[0])){ Cancela(2,0); ObjectDelete("PRLA");}         
      }
     if (ObjectFind("STLB") == 0)
      {
         // if the subwindow number is -1, there is an error
         debug = debug + ("STOP LB AT "+ObjectGet("STLB",OBJPROP_PRICE1 )+"\n");
         ObjectSet("STLB",OBJPROP_WIDTH,2);
         ObjectSet("STLB",OBJPROP_COLOR,Brown);
         ObjectSet("STLB",OBJPROP_STYLE,STYLE_DASH);         
         if ((ObjectGet("STLB",OBJPROP_PRICE1 )) > (Close[0])) {Cancela(3,0); ObjectDelete("STLB");}
                  
      }
      if (ObjectFind("PRLB") == 0)
      {
         // if the subwindow number is -1, there is an error
         debug = debug + ("PROFIT LB AT "+ObjectGet("PRLB",OBJPROP_PRICE1 )+"\n");
         ObjectSet("PRLB",OBJPROP_WIDTH,2);
         ObjectSet("PRLB",OBJPROP_COLOR,MediumSpringGreen);
         ObjectSet("PRLB",OBJPROP_STYLE,STYLE_DASH); 
         if ((ObjectGet("PRLB",OBJPROP_PRICE1 )) < (Close[0])) { Cancela(3,0);ObjectDelete("PRLB"); }
         
      }



for (  zz = 0; zz < 100; zz ++)  
{
     if (ObjectFind("GBUYLF"+zz) == 0) 
     {
         spread = 0;
         debug = debug + ("BUY LF AT "+ObjectGet("GBUYLF"+zz,OBJPROP_PRICE1 )+"\n");
         ObjectSet("GBUYLF"+zz,OBJPROP_WIDTH,2);
         ObjectSet("GBUYLF"+zz,OBJPROP_COLOR,MintCream);
         ObjectSet("GBUYLF"+zz,OBJPROP_STYLE,STYLE_SOLID);         
         if ((ObjectGet("GBUYLF"+zz,OBJPROP_PRICE1 )) > (Close[0])) {  Op_Compra(10,0,QT,zz);} // C
     }
     if (ObjectFind("GSELLLF"+zz) == 0) 
     {
         spread = 0;
         debug = debug + ("SELL LA AT "+ObjectGet("SELLLF"+zz,OBJPROP_PRICE1 )+"\n");
         ObjectSet("GSELLLF"+zz,OBJPROP_WIDTH,2);
         ObjectSet("GSELLLF"+zz,OBJPROP_COLOR,MintCream);
         ObjectSet("GSELLLF"+zz,OBJPROP_STYLE,STYLE_SOLID);         
         if ((ObjectGet("GSELLLF"+zz,OBJPROP_PRICE1 )) < (Close[0])) {  Op_Venda(11,0,QT,zz);} // C
     }     
}


for (  zz = 0; zz < 100; zz ++)  
{
     if (ObjectFind("GPRLF-"+zz) == 0) 
     {
         spread = 0;
         debug = debug + ("BUY LF AT "+ObjectGet("GBUYLF"+zz,OBJPROP_PRICE1 )+"\n");
         ObjectSet("GPRLF-"+zz,OBJPROP_WIDTH,1);
         ObjectSet("GPRLF-"+zz,OBJPROP_COLOR,MintCream);
         ObjectSet("GPRLF-"+zz,OBJPROP_STYLE,STYLE_DOT);         
         if ((ObjectGet("GPRLF-"+zz,OBJPROP_PRICE1 )) < (Close[0])) { Cancela(0,zz); } // C  vinicius
     }
     if (ObjectFind("GSTLF-"+zz) == 0) 
     {
         spread = 0;
         debug = debug + ("SELL LA AT "+ObjectGet("SELLLF"+zz,OBJPROP_PRICE1 )+"\n");
         ObjectSet("GSTLF-"+zz,OBJPROP_WIDTH,1);
         ObjectSet("GSTLF-"+zz,OBJPROP_COLOR,MintCream);
         ObjectSet("GSTLF-"+zz,OBJPROP_STYLE,STYLE_DOT);         
         if ((ObjectGet("GSTLF-"+zz,OBJPROP_PRICE1 )) > (Close[0])) { Cancela(0,zz); } // C
     }     
}







/////////////////////////////
// deciso
/////////////////////////////
DrawArrow("BandUpBfr",  Time[0], BandUpBfr[0], 159, Aqua, 1);
DrawArrow("BandDwBfr",  Time[0], BandDwBfr[0], 159, Red, 1);
DrawArrow("AuxRegBfr",  Time[0], AuxRegBfr[0], 159, Blue, 1);

cnt = cnt + 1;


/////////////////////////////
// execuo
/////////////////////////////

if ((L_cod_operacao != 111) && (cod_operacao == 111))
{
   if (Borda_Inversa == true)
   {
      if (LA == true) Op_Compra(cod_operacao,2,QT,0);
   } else
   {
      if (LA == true) Op_Venda(cod_operacao,2,QT,0);
   }
}
if ((L_cod_operacao != 112) && (cod_operacao == 112))
{
   if (Borda_Inversa == true)
   {
     if (LB == true) Op_Venda(cod_operacao,3,QT,0);
   } else
   {
     if (LB == true) Op_Compra(cod_operacao,3,QT,0);
   }
}

////// line LA
if ((cod_operacao == 1150))
{
  Op_Compra(cod_operacao,2,QT,0);
}
if ( (cod_operacao == 1151))
{
  Op_Venda(cod_operacao,2,QT,0);
}

/////// PRINCIPAL
if ( (cod_operacao == 444))
{
  if (spread == 0) double QQT = QT;
  if (spread != 0) QQT = QT_spread;
  spread = 0;
  Op_Compra(cod_operacao,1,QQT,0);
}
if ( (cod_operacao == 555))
{  
  if (spread == 0) QQT = QT;
  if (spread != 0) QQT = QT_spread;
  spread = 0;
  Op_Venda(cod_operacao,1,QQT,0);
}


/////// SECUNDARIOS SPREAD
if ( (cod_operacao == 9998))
{
  QQT = QT_spread;
  spread = 0;
  Op_Compra(cod_operacao,1,QQT,0);
}
if ( (cod_operacao == 9999))
{  
  QQT = QT_spread;
  spread = 0;
  Op_Venda(cod_operacao,1,QQT,0);
}


////// line LB
if ((L_cod_operacao != 888) && (cod_operacao == 888))
{
  Op_Compra(cod_operacao,3,QT,0);
}
if ((L_cod_operacao != 999) && (cod_operacao == 999))
{
  Op_Venda(cod_operacao,3,QT,0);
}
////////////////////////////////////
   
if ((L_cod_operacao != 191) && (cod_operacao == 191))
{
  Op_Compra(cod_operacao,1,QT,0);
  //Alert("Operando inverso LF Compra "+Symbol());
}   
if ((L_cod_operacao != 199) && (cod_operacao == 199))
{
  Op_Venda(cod_operacao,1,QT,0);
  //Alert("Operando inverso LF Venda "+Symbol());
}   





/////////////////
// Filmagem
/////////////////
if (ScreenShotVini != TimeMinute(TimeCurrent())) 
{
   numloop = numloop + 1;
   ScreenShotVini = TimeMinute(TimeCurrent());   
}

  if((ScreenShotStep>0)                       // is it necessary to make screenshots?          
    && (numloop > ScreenShotViniStep))    
  {
    // compose the filename and save the screenshot under it
    FileName=FilesPrefix+StringSubstr(DoubleToStr(ScreenShotCur,5),2)+".gif";   
    WindowScreenShot(Symbol()+ "_" + TimeDay(Time[0]) +"_"+ TimeMonth(Time[0]) +"_"+ FileName,800,600);
    
    // give a prompt
    numloop = 0;
     
    // shift the data and the counter to the next screenshot
    ScreenShotCur+=0.00001;
    NextScreenShot=Time[0]+ScreenShotStep*Period()*60;   
  }
 
if(ScreenShotCur*1000>ScreenShotMax+1) Comment("All screenshots are saved");
if (IsDemo()) passos = passos + " Demo T:"+ trend;  


////////////////////////////
//  outras noticias;
//////////////////////////// 
    if (OrdersTotal() != 0)
    {
        for(i=0;i<OrdersTotal();i++)
        {      
          if (OrderSelect(i,SELECT_BY_POS))
          {
            if (OrderLots() > QT_MAX)
            {
              acao = data+"!!!!!EMERGENCIA !!! LOTE SUPERIOR AO PERMITIDO !      !!!!!EMERGENCIA !!! LOTE SUPERIOR AO PERMITIDO !";
              //PlaySound("email.wav");
              if(LF > 20) Cancela(1,0);
            }          
          }
       }
    }


/////////////
string newsdisk = newsRead();
if (((acao == acao1) && (acao != "")) && ((acao1 != newsdisk)&& (acao != newsdisk)))
{
acao4 = acao3;
acao3 = acao2;
acao2 = acao1;
acao1 = newsdisk;
acao = newsdisk;
//PlaySound("beep.wav");
cnt_news = 0;
} 
if ((acao != acao1) || (acao == ""))
{
acao4 = acao3;
acao3 = acao2;
acao2 = acao1;
acao1 = acao;
cnt_news = 0;
newsWrite(acao);
//PlaySound("beep.wav");
}
   digits_corretora = MarketInfo(Symbol(),MODE_DIGITS);
   double STOPLEVEL = MarketInfo(Symbol(),MODE_STOPLEVEL);
   
   int WindowNumber = WindowFind("news");
   string ObjName = "atranews";
   cnt_news = cnt_news + 1; 
   if(ObjectFind(ObjName) == -1) 
   {
      //ObjectCreate(ObjName, OBJ_LABEL, WindowNumber, EMPTY_VALUE,EMPTY_VALUE);
      //ObjectSet(ObjName, OBJPROP_WIDTH, 1600);
      //ObjectSetText(ObjName, "NEWS VINI APRESENTA !", 10, "Arial Black", White);
      //ObjectSet(ObjName, OBJPROP_CORNER, 1);
      //ObjectSet(ObjName, OBJPROP_XDISTANCE, 1);
      //ObjectSet(ObjName, OBJPROP_YDISTANCE, 1);   
   } else
   {   
              if (cnt_news < 10)
              { 
                string publicacao = acao1;
              }
              
                if ((cnt_news > 10) && (acao2 != ""))
                    publicacao = acao2;
                if ((cnt_news > 15) && (acao3 != ""))
                    publicacao = acao3;
                if ((cnt_news > 20) && (acao4 != ""))
                    publicacao = acao4;
                if ((cnt_news > 25) && (acao5 != ""))
                    publicacao = acao5;
                if (cnt_news > 30) cnt_news = 0;
                  
              if (cnt_news < 10)
                ObjectSetText(ObjName, publicacao, 10, "Arial Black", Yellow);
              if (cnt_news > 10)
                ObjectSetText(ObjName, publicacao, 10, "Arial Black", LightSlateGray);              
              
              ObjectSet(ObjName, OBJPROP_WIDTH, 1600);
   }
   
Comment(IND+VER+" - QT: "+QT  + " QT2 "+QT_spread +"Digits:"+digits_corretora+"STOPLEVEL:"+STOPLEVEL+" LF: "+ LF +"\n \n \n \n \n\n \n \n \n \n \n\n\n"+" "+acao1+"\n"+""+acao2+"\n"+""+acao3+"\n"+""+acao4); 
debug = "";  
passos = "";   

   // ----

   return(0);
  }

//+--------------------------------------------------------------------------------------------------+
//| Custom indicator deinitialization function                                                       |
//+--------------------------------------------------------------------------------------------------+
int deinit()
  {
//   Comment("");
   if(c_handle>0)
      FileClose(c_handle);

   if(c_handle>0)
      FileClose(c_handle);
   
   ObjectDelete("Resistance line");
   ObjectDelete("Support line");
   del("Crossing ");
   if (delete_segments==true) del("border");
   
   //----
   return(0);
  }

void PolynomialRegression(int grade)
   {
    // y=c0+c1x+c2x^2+c3x^3...cnx^n
    // grade+1    nmero de funciones y de coeficientes a calcular
    // 2*grade    valor del mayor exponente
    // datapoints nmero de valores a considerar
    // pos        first value position (left to right direction)
    int     exp,k,row,col,
            initialrow,initialcol,
            loop,i,j;
    double  sumx,sumyx,sum;
   
    ArrayResize(sumxvalues,2*grade+1);
    ArrayResize(sumyxvalues,grade+1);
    ArrayInitialize(sumxvalues,0.0);
    ArrayInitialize(sumyxvalues,0.0);
    sumxvalues[0]=datapoints;
    for(exp=1;exp<=2*grade;exp++)
      {
       sumx=0.0;
       sumyx=0.0;
       for(k=1;k<=datapoints;k++)
         {
          sumx+=MathPow(k,exp);
          if(exp==1)
            sumyx+=Close[pos-k+1];
          else if(exp<=grade+1)
            sumyx+=Close[pos-k+1]*MathPow(k,exp-1);
         }
       sumxvalues[exp]=sumx;
       if(sumyx!=0.0)
         sumyxvalues[exp-1]=sumyx;
      }
    ArrayResize(matrix,grade+1);
    ArrayInitialize(matrix,0.0);
    for(row=0;row<=grade;row++)
      for(col=0;col<=grade;col++)
         matrix[row][col]=sumxvalues[row+col];
    initialrow=1;
    initialcol=1;
    for(loop=1;loop<=grade;loop++)
      {
       for(row=initialrow;row<=grade;row++)
         {
          sumyxvalues[row]=sumyxvalues[row]-(matrix[row][loop-1]/matrix[loop-1][loop-1])*sumyxvalues[loop-1];
          for(col=initialcol;col<=grade;col++)
            matrix[row][col]=matrix[row][col]-(matrix[row][loop-1]/matrix[loop-1][loop-1])*matrix[loop-1][col];
         }
       initialrow++;
       initialcol++;
      }
    ArrayResize(constant,grade+1);
    ArrayInitialize(constant,0.0);
    j=0;
    for(i=grade;i>=0;i--)
      {
       if(j==0)
          constant[i]=sumyxvalues[i]/matrix[i][i];
       else
         {
          sum=0.0;
          for(k=j;k>0;k--)
            sum+=constant[i+k]*matrix[i][i+k];
          constant[i]=(sumyxvalues[i]-sum)/matrix[i][i];
         }
       j++;
      }
    ArrayInitialize(AuxRegBfr,EMPTY_VALUE);
    k=1;
    for(i=datapoints-1;i>=0;i--)
      {
       sum=0.0;
       for(j=0;j<=grade;j++)
         sum+=constant[j]*MathPow(k,j);
       AuxRegBfr[i+endpos]=sum;
       k++;
      }
   }

void LogarithmicRegression()
   {
    // y=c0*x^c1
    // lny=lnc0+c1lnx <=> y=a+bx
    // c0=e^a
    // c1=b
    int     exp,k,row,col,
            initialrow,initialcol,
            loop,i,j;
    double  sumx,sumyx,lnx,a;
   
    ArrayResize(sumxvalues,3);
    ArrayResize(sumyxvalues,2);
    ArrayInitialize(sumxvalues,0.0);
    ArrayInitialize(sumyxvalues,0.0);
    sumxvalues[0]=datapoints;
    for(exp=1;exp<=2;exp++)
      {
       sumx=0.0;
       sumyx=0.0;
       for(k=1;k<=datapoints;k++)
         {
          lnx=MathLog(k);
          sumx+=MathPow(lnx,exp);
          if(exp==1)
            sumyx+=MathLog(Close[pos-k+1]);
          else
            sumyx+=MathLog(Close[pos-k+1])*MathPow(lnx,exp-1);
         }
       sumxvalues[exp]=sumx;
       if(sumyx!=0.0)
         sumyxvalues[exp-1]=sumyx;
      }
    ArrayResize(matrix,2);
    ArrayInitialize(matrix,0.0);
    for(row=0;row<=1;row++)
      for(col=0;col<=1;col++)
         matrix[row][col]=sumxvalues[row+col];
    sumyxvalues[1]=sumyxvalues[1]-(matrix[1][0]/matrix[0][0])*sumyxvalues[0];
    matrix[1][1]=matrix[1][1]-(matrix[1][0]/matrix[0][0])*matrix[0][1];
    ArrayResize(constant,2);
    ArrayInitialize(constant,0.0);
    constant[1]=sumyxvalues[1]/matrix[1][1];
    a=(sumyxvalues[0]-(constant[1]*matrix[0][1]))/matrix[0][0];
    constant[0]=MathExp(a);
    ArrayInitialize(AuxRegBfr,EMPTY_VALUE);
    k=1;
    for(i=datapoints-1;i>=0;i--)
      {
       AuxRegBfr[i+endpos]=constant[0]*MathPow(k,constant[1]);
       k++;
      }
   }

void ExponentialRegression()
   {
    // y=c0*e^(xc1)
    // lny=lnc0+c1x <=> y=a+bx
    // c0=e^a
    // c1=b
    int     exp,k,row,col,
            initialrow,initialcol,
            loop,i,j;
    double  sumx,sumyx,a;
   
    ArrayResize(sumxvalues,3);
    ArrayResize(sumyxvalues,2);
    ArrayInitialize(sumxvalues,0.0);
    ArrayInitialize(sumyxvalues,0.0);
    sumxvalues[0]=datapoints;
    for(exp=1;exp<=2;exp++)
      {
       sumx=0.0;
       sumyx=0.0;
       for(k=1;k<=datapoints;k++)
         {
          sumx+=MathPow(k,exp);
          if(exp==1)
            sumyx+=MathLog(Close[pos-k+1]);
          else
            sumyx+=MathLog(Close[pos-k+1])*MathPow(k,exp-1);
         }
       sumxvalues[exp]=sumx;
       if(sumyx!=0.0)
         sumyxvalues[exp-1]=sumyx;
      }
    ArrayResize(matrix,2);
    ArrayInitialize(matrix,0.0);
    for(row=0;row<=1;row++)
      for(col=0;col<=1;col++)
         matrix[row][col]=sumxvalues[row+col];
    sumyxvalues[1]=sumyxvalues[1]-(matrix[1][0]/matrix[0][0])*sumyxvalues[0];
    matrix[1][1]=matrix[1][1]-(matrix[1][0]/matrix[0][0])*matrix[0][1];
    ArrayResize(constant,2);
    ArrayInitialize(constant,0.0);
    constant[1]=sumyxvalues[1]/matrix[1][1];
    a=(sumyxvalues[0]-(constant[1]*matrix[0][1]))/matrix[0][0];
    constant[0]=MathExp(a);
    ArrayInitialize(AuxRegBfr,EMPTY_VALUE);
    k=1;
    for(i=datapoints-1;i>=0;i--)
      {
       AuxRegBfr[i+endpos]=constant[0]*MathExp(k*constant[1]);
       k++;
      }
   }

void BestReg()
   {
    string  short_name;
    double  currentstddev;
    int     c_stddevindex,i;
   
  //  Comment("LinReg=",errorstddev[0]," || QuadReg=",errorstddev[1]," || LogReg=",errorstddev[2]," || ExpReg=",errorstddev[3]);
    currentstddev=errorstddev[0];
    c_stddevindex=0;
    for(i=1;i<=3;i++)
      {
       if(errorstddev[i]<currentstddev)
         {
          currentstddev=errorstddev[i];
          c_stddevindex=i;
         }
      }
    switch(c_stddevindex)
      {
       case 0 : PolynomialRegression(1); short_name="LinReg";  break;
       case 1 : PolynomialRegression(2); short_name="QuadReg"; break;
       case 2 : LogarithmicRegression(); short_name="LogReg";  break;
       case 3 : ExponentialRegression(); short_name="ExpReg";  break;
       default :PolynomialRegression(1); short_name="LinReg";
      }
    SetIndexLabel(0,short_name);
    IndicatorShortName(short_name+"("+datapoints+")");
    ArrayInitialize(RegBfr,EMPTY_VALUE);
    for(i=datapoints-1;i>=0;i--)
      RegBfr[i+endpos]=AuxRegBfr[i+endpos];
   }

double StdDevRegError()
   {
    int     i;
    double  sum,arithmean,stddev;
    
    sum=0.0;
    for(i=datapoints-1;i>=0;i--)
      sum+=MathAbs(Close[i+endpos]-AuxRegBfr[i+endpos]);
    if(datapoints<=0) datapoints=1;
    arithmean=sum/datapoints;
    sum=0.0;
    for(i=datapoints-1;i>=0;i--)
      sum+=(Close[i+endpos]-AuxRegBfr[i+endpos]-arithmean)*(Close[i+endpos]-AuxRegBfr[i+endpos]-arithmean);
    if(datapoints<=0) datapoints=1;
    stddev=MathSqrt(sum/datapoints);
    return(stddev);
   }

void ConfidenceBands()
   {
    int     i;
    double  sum,variance;
    
    sum=0.0;
    for(i=datapoints-1;i>=0;i--)
      sum+=(Close[i+endpos]-RegBfr[i+endpos])*(Close[i+endpos]-RegBfr[i+endpos]);
    variance=MathSqrt(sum/datapoints);
    ArrayInitialize(BandUpBfr,EMPTY_VALUE);
    ArrayInitialize(BandDwBfr,EMPTY_VALUE);
    for(i=datapoints-1;i>=0;i--)
      {
       BandUpBfr[i+endpos]=RegBfr[i+endpos]+(multStdDev*variance);
       BandDwBfr[i+endpos]=RegBfr[i+endpos]-(multStdDev*variance);
      }
   }
//////////////////////
//grafista
///////////////////////  

//+------------------------------------------------------------------+
int grafista()
{
   while(true)
   {
      if (time_period!=Time[0])
      {
         if (bar_3u != find_fractal(0, 1) || (ObjectFind("Resistance line")!=0))
         {
            bar_3u = find_fractal(0,     1);
            bar_2u = find_fractal(bar_3u,-1);
            bar_1u = find_fractal(bar_2u, 1);
            X1u=Time[bar_1u];Y1u=High[bar_1u];X2u=Time[bar_3u];Y2u=High[bar_3u];
            ObjectDelete("Resistance line");
            ObjectCreate("Resistance line", OBJ_TREND, 0,X1u,Y1u,X2u,Y2u);
            ObjectSet   ("Resistance line", OBJPROP_COLOR, Color_resistance);
            ObjectSet   ("Resistance line", OBJPROP_STYLE, STYLE_DASH);
            ObjectSet   ("Resistance line", OBJPROP_WIDTH, 0);
            ObjectSet   ("Resistance line", OBJPROP_BACK,  true);
            ObjectSet   ("Resistance line", OBJPROP_RAY,   true);
            draw_borders(Color_resistance,X1u,Y1u,X2u,Y2u);
         }
         //-----------------------------------------------------------------------
         if (bar_3d != find_fractal(0,-1) || (ObjectFind("Support line")!=0))
         {
            bar_3d = find_fractal(0,    -1);
            bar_2d = find_fractal(bar_3d, 1);
            bar_1d = find_fractal(bar_2d,-1);
            X1d=Time[bar_1d];Y1d=Low[bar_1d];X2d=Time[bar_3d];Y2d=Low[bar_3d];
            ObjectDelete("Support line");
            ObjectCreate("Support line", OBJ_TREND, 0,X1d,Y1d,X2d,Y2d);
            ObjectSet   ("Support line", OBJPROP_COLOR, Color_support);
            ObjectSet   ("Support line", OBJPROP_STYLE, STYLE_DASH);
            ObjectSet   ("Support line", OBJPROP_WIDTH, 0);
            ObjectSet   ("Support line", OBJPROP_BACK,  true);    
            ObjectSet   ("Support line", OBJPROP_RAY,   true);
            draw_borders(Color_support,X1d,Y1d,X2d,Y2d);
         }
         //-----------------------------------------------------------------------
         int d=0;
         int    X_1,X_2;
         double Y_1,Y_2;
         color COLOR;
         for(int n=ObjectsTotal()-1; n>=0; n--) 
         {
            string Obj_N=ObjectName(n);
            if (StringFind(Obj_N,"border",0)!=-1 && ObjectType(Obj_N)==OBJ_TREND)
            // we have found an object - trend for calculation of the approach
            {
               X_1 = ObjectGet(Obj_N, OBJPROP_TIME1); 
               X_2 = ObjectGet(Obj_N, OBJPROP_TIME2); 
               if (X_1==X_2) {ObjectDelete(Obj_N);continue;}
               Y_1 = ObjectGet(Obj_N, OBJPROP_PRICE1);
               Y_2 = ObjectGet(Obj_N, OBJPROP_PRICE2);
               COLOR= ObjectGet(Obj_N, OBJPROP_COLOR);
               // drawing the control zone (Obj_N, COLOR, X_1,Y_1,X_2,Y_2);
               if (X_1<=Time[0] && X_2>=Time[0])//it's in the time range
               {
                  X3d=Time[0];Y3d=Y_1+(Y_2-Y_1)*(X3d-X_1)/(X_2-X_1);// line equation
                  //Comment((Y3d-Bid)/Point);
                  if (MathAbs(Y3d-Bid)/Point < Set)
                  { 
                     if (COLOR==Color_resistance)//Lower border
                           {d=-1;break;}
                     else  {d= 1;break;}
                  }
               }
            }
         }
         //-----------------------------------------------------------------------
         if (d!=0)
         {
            ObjectCreate("Crossing "+Obj_N+" "+Time[0], OBJ_ARROW,0,Time[0],Bid,0,0,0,0);
            ObjectSet   ("Crossing "+Obj_N+" "+Time[0], OBJPROP_WIDTH, 0);
            if (d==1)
            {
               ObjectSet   ("Crossing "+Obj_N+" "+Time[0], OBJPROP_ARROWCODE,233);
               ObjectSet   ("Crossing "+Obj_N+" "+Time[0], OBJPROP_COLOR, Color_support);    // Color   
               //Alert(Symbol()+" - Crossing the border of support "+Obj_N);
               acao = data+ " - "+Symbol()+" - Crossing the border of support "+Obj_N;
            }
            else
            {
               ObjectSet   ("Crossing "+Obj_N+" "+Time[0], OBJPROP_ARROWCODE,234);
               ObjectSet   ("Crossing "+Obj_N+" "+Time[0], OBJPROP_COLOR, Color_resistance);    // Color
               //Alert(Symbol()+" - Crossing the border of resistance "+Obj_N);
               acao = data+" - "+Symbol()+" - Crossing the border of resistance "+Obj_N;
            }
            time_period=Time[0];
         }
      }
      if ((ObjectFind("Lower border "+string_period(per))==0)&&(ObjectFind("Upper border "+string_period(per))==0)) 
         return(0);
      else 
      {
         ObjectDelete("Resistance line");
         ObjectDelete("Support line");
         time_period=Time[1];
      }
   }
}
//+------------------------------------------------------------------+
int find_fractal(int bar, int UP_DN)
{
   while(true)//looking for 1 fractal after bar
   {
      bar++;
      if (UP_DN == 1 && iFractals(NULL, 0, MODE_UPPER, bar) != 0) return(bar);
      if (UP_DN ==-1 && iFractals(NULL, 0, MODE_LOWER, bar) != 0) return(bar);
   } 
   return(0);  
}
//+------------------------------------------------------------------+
int del(string Ob)
{
   for(int n=ObjectsTotal()-1; n>=0; n--) 
   {
      string Obj_Name=ObjectName(n);
      if (StringFind(Obj_Name,Ob,0) != -1) ObjectDelete(Obj_Name);
   }
   return;
}
//+------------------------------------------------------------------+
string string_period(int p)
{  switch(p)
   {  case 1    : return("M_1"); break;  //1 min
      case 5    : return("M_5"); break;  //5 min
      case 15   : return("M15"); break; //15 min
      case 30   : return("M30"); break; //30 min
      case 60   : return("H 1"); break;  //1 hour
      case 240  : return("H_4"); break;  //4 hours
      case 1440 : return("D_1"); break;  //1 day
      case 10080: return("W_1"); break;  //1 week
      case 43200: return("MN1"); break; //1 month
   }return("period error");
}
//+------------------------------------------------------------------+
int draw_borders(color COLOR,int X1,double Y1,int X2,double Y2)
{
   string Name = "border "+string_period(per);
   if (COLOR==Color_resistance) Name = "Upper "+Name;
   if (COLOR==Color_support)     Name = "Lower " +Name;
   if (ObjectFind(Name)==0) return; //If the object exists
   X1g=Time[0];X2g=Time[0]+per*60*time_set;
   if (COLOR==Color_resistance) {Y1vg=Y1+(Y2-Y1)*(X1g-X1)/(X2-X1);Y2vg=Y1+(Y2-Y1)*(X2g-X1)/(X2-X1);
                                  ObjectCreate(Name, OBJ_TREND, 0,X1g,Y1vg,X2g,Y2vg);}
   if (COLOR==Color_support)     {Y1ng=Y1+(Y2-Y1)*(X1g-X1)/(X2-X1);Y2ng=Y1+(Y2-Y1)*(X2g-X1)/(X2-X1);
                                  ObjectCreate(Name, OBJ_TREND, 0,X1g,Y1ng,X2g,Y2ng);}
   ObjectSet   (Name, OBJPROP_COLOR, COLOR);
   ObjectSet   (Name, OBJPROP_STYLE, STYLE_SOLID);
   ObjectSet   (Name, OBJPROP_WIDTH, 4);
   ObjectSet   (Name, OBJPROP_BACK,  false);
   ObjectSet   (Name, OBJPROP_RAY,   false);
   return;
}
//+------------------------------------------------------------------+


//+------------------------------------------------------------------+
bool limitacao_hora()
{
bool respo = true;
  int h=TimeHour(TimeCurrent());
  if ((h == 21) || (h == 22) || (h == 23)) //  || (h == 01)
  {
     respo = false;
  }

  return(respo);
}

void WriteIniFile(string strFile)
{ 
 if (IsDemo()) return(0);
 int handle0 = FileOpen(strFile, FILE_CSV|FILE_WRITE, ";");            
 if (handle0 > 0) 
   {
     FileWrite(handle0, ScreenShotCur);     
     FileWrite(handle0, NUM_CONTA);               
     FileWrite(handle0, LA);
     FileWrite(handle0, LB);
     FileWrite(handle0, LF);          
     FileWrite(handle0, decimais_multiplo);          
     FileWrite(handle0, lambda);  
     FileWrite(handle0, gat10);  
     FileWrite(handle0, gat50);  
     FileWrite(handle0, gat100);  
          
     FileClose(handle0);
  } 
 return (0);
}

 void LoadSymbolArray(string strFile)
  {
   ScreenShotCur = 10;
   int x=0;
   //passos = passos + "Carregando Configuraes ";
   double handle1=FileOpen(strFile, FILE_CSV|FILE_READ, ";");
    
   if(handle1>0)
    {
       if (IsDemo()) return(0);
      // Successive calls to FileReadString pick up chunks ending with the delimiter or the end-of-row
        ScreenShotCur = StrToDouble(FileReadString(handle1));
        NUM_CONTA = StrToInteger(FileReadString(handle1));               
        int LAA = StrToInteger(FileReadString(handle1));
        int LBB = StrToInteger(FileReadString(handle1));
        int LFF = StrToInteger(FileReadString(handle1));
        decimais_multiplo = StrToDouble(FileReadString(handle1));        
        double lbd = StrToDouble(FileReadString(handle1));
        gat10 = StrToInteger(FileReadString(handle1));        
        gat50 = StrToInteger(FileReadString(handle1));        
        gat100 = StrToInteger(FileReadString(handle1));        
        
        FileClose(handle1);

        if (lbd != 0) lambda = lbd;
        saveb = 1;   
    }
   else 
   {
    Print("INI file missing: ", strFile);
    return (0);
   }
  return(0);
  }
  
void drawLine(double lvl,string name, color Col,int type)
{
         if(ObjectFind(name) != 0)
         {
            ObjectCreate(name, OBJ_HLINE, 0, Time[0], lvl,Time[0],lvl);
            
            if(type == 1)
            ObjectSet(name, OBJPROP_STYLE, STYLE_SOLID);
            else
            ObjectSet(name, OBJPROP_STYLE, STYLE_DOT);
            
            ObjectSet(name, OBJPROP_COLOR, Col);
            ObjectSet(name,OBJPROP_WIDTH,1);
            
         }
         else
         {
            ObjectDelete(name);
            ObjectCreate(name, OBJ_HLINE, 0, Time[0], lvl,Time[0],lvl);
            
            if(type == 1)
            ObjectSet(name, OBJPROP_STYLE, STYLE_SOLID);
            else
            ObjectSet(name, OBJPROP_STYLE, STYLE_DOT);
            
            ObjectSet(name, OBJPROP_COLOR, Col);        
            ObjectSet(name,OBJPROP_WIDTH,1);
          
         }
}



void newsWrite(string texto)
{ 
 double handle10 = FileOpen("news.txt", FILE_CSV|FILE_WRITE, ";");            
 if (handle10 > 0) 
   {
     FileWrite(handle10, texto);     
  } 
 FileClose(handle10);
 return (0);
}

string newsRead()
{
string last = "";
 double handle10=FileOpen("news.txt", FILE_CSV|FILE_READ, ";");
 if(handle10>0)
 {
     last = FileReadString(handle10);        
 }
 FileClose(handle10);
 return(last);
}

int Explode(string str, string delimiter, string& arr[])
{
   int i = 0;
   int pos = StringFind(str, delimiter);
   while(pos != -1)
   {
      if(pos == 0) arr[i] = ""; else arr[i] = StringSubstr(str, 0, pos);
      i++;
      str = StringSubstr(str, pos+StringLen(delimiter));
      pos = StringFind(str, delimiter);
      if(pos == -1 || str == "") break;
   }
   arr[i] = str;
 
   return(i+1);
}


